/*
 * Decompiled with CFR 0.152.
 */
package fileconverters;

import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.ClonePair;
import de.uni_bremen.st.rcf.model.Directory;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.persistence.AbstractPersistenceManager;
import de.uni_bremen.st.rcf.persistence.PersistenceManagerFactory;
import fileconverters.Fileconverters;
import java.io.File;
import java.util.ArrayList;

public class FileConverterForRCF
extends Fileconverters {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convert(File f, ArrayList list) {
        String output = "";
        try {
            String filename = (String)list.get(0);
            File fold = new File(filename);
            if (!fold.exists()) {
                System.out.println("the file does not exist!!");
            } else {
                AbstractPersistenceManager apm = PersistenceManagerFactory.getPersistenceManager(fold);
                if (apm != null) {
                    RCF rcfold = apm.load(fold);
                    if (list.size() == 1) {
                        output = FileConverterForRCF.converter(rcfold);
                    } else if (list.size() == 2) {
                        String strminimiumlines = (String)list.get(1);
                        int minimumlines = Integer.parseInt(strminimiumlines);
                        output = FileConverterForRCF.convertermin(rcfold, minimumlines);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return output;
    }

    public static String converter(RCF rcfold) {
        StringBuffer sbGCFfile = new StringBuffer();
        sbGCFfile.append("<CloneClasses>\r\n");
        int minimumline = 0;
        for (Version v : rcfold.getVersions()) {
            for (CloneClass cc : v.getCloneClasses()) {
                StringBuffer sb = new StringBuffer();
                int cloneClassID = cc.getId();
                sb.append("<CloneClass>\r\n");
                sb.append("<ID>");
                sb.append(Integer.toString(cloneClassID));
                sb.append("</ID>\r\n");
                for (Fragment f : cc.getFragments()) {
                    String strreplace;
                    SourcePosition start = f.getStart();
                    SourcePosition end = f.getEnd();
                    int linecount = end.getLine() - start.getLine() + 1;
                    if (minimumline == 0 || linecount < minimumline) {
                        minimumline = linecount;
                    }
                    de.uni_bremen.st.rcf.model.File startfile = start.getFile();
                    Directory startdirectory = startfile.getDirectory();
                    String strpath = startdirectory.getPath() + "\\" + startfile.getName();
                    strpath = strreplace = strpath.replaceAll("/", "\\\\");
                    String strstart = "\\";
                    if (!strpath.startsWith("\\")) {
                        strpath = strstart.concat(strpath);
                    }
                    String path = "<File>" + strpath + "</File>\r\n";
                    String line = "";
                    line = line + "<Start>" + start.getLine() + "</Start>\r\n";
                    line = line + "<End>" + end.getLine() + "</End>\r\n";
                    sb.append("<Clone>\r\n");
                    sb.append("<Fragment>\r\n");
                    sb.append(path);
                    sb.append(line);
                    sb.append("</Fragment>\r\n</Clone>\r\n");
                }
                sbGCFfile.append(sb.toString());
                sbGCFfile.append("</CloneClass>\r\n");
            }
            for (ClonePair cp : v.getClonePairs()) {
                String strreplace;
                Fragment fl = cp.getLeft();
                SourcePosition startleft = fl.getStart();
                SourcePosition endleft = fl.getEnd();
                int linecount1 = endleft.getLine() - startleft.getLine() + 1;
                Fragment fr = cp.getRight();
                SourcePosition startright = fr.getStart();
                SourcePosition endright = fr.getEnd();
                int linecountr = endright.getLine() - startright.getLine() + 1;
                int cloneClassID = cp.getId();
                sbGCFfile.append("<CloneClass>\r\n");
                sbGCFfile.append("<ID>");
                sbGCFfile.append(Integer.toString(cloneClassID));
                sbGCFfile.append("</ID>\r\n");
                de.uni_bremen.st.rcf.model.File startfile = startleft.getFile();
                Directory startdirectory = startfile.getDirectory();
                String strpath = startdirectory.getPath() + "\\" + startfile.getName();
                strpath = strreplace = strpath.replaceAll("/", "\\\\");
                String strstart = "\\";
                if (!strpath.startsWith("\\")) {
                    strpath = strstart.concat(strpath);
                }
                String path = "<File>" + strpath + "</File>\r\n";
                String line = "";
                line = line + "<Start>" + startleft.getLine() + "</Start>\r\n";
                line = line + "<End>" + endleft.getLine() + "</End>\r\n";
                sbGCFfile.append("<Clone>\r\n");
                sbGCFfile.append("<Fragment>\r\n");
                sbGCFfile.append(path);
                sbGCFfile.append(line);
                sbGCFfile.append("</Fragment>\r\n</Clone>\r\n");
                startfile = startright.getFile();
                startdirectory = startfile.getDirectory();
                strpath = startdirectory.getPath() + "\\" + startfile.getName();
                strpath = strreplace = strpath.replaceAll("/", "\\\\");
                path = "<File>" + strpath + "</File>\r\n";
                line = "";
                line = line + "<Start>" + startright.getLine() + "</Start>\r\n";
                line = line + "<End>" + endright.getLine() + "</End>\r\n";
                sbGCFfile.append("<Clone>\r\n");
                sbGCFfile.append("<Fragment>\r\n");
                sbGCFfile.append(path);
                sbGCFfile.append(line);
                sbGCFfile.append("</Fragment>\r\n</Clone>\r\n");
                sbGCFfile.append("</CloneClass>\r\n");
            }
            sbGCFfile.append("</CloneClasses>\r\n");
        }
        System.out.println(minimumline);
        return sbGCFfile.toString();
    }

    public static String convertermin(RCF rcfold, int minimumlines) {
        StringBuffer sbGCFfile = new StringBuffer();
        sbGCFfile.append("<CloneClasses>\r\n");
        for (Version v : rcfold.getVersions()) {
            for (CloneClass cc : v.getCloneClasses()) {
                StringBuffer sb = new StringBuffer();
                int cloneClassID = cc.getId();
                sb.append("<CloneClass>\r\n");
                sb.append("<ID>");
                sb.append(Integer.toString(cloneClassID));
                sb.append("</ID>\r\n");
                int fragmentcountofclass = 0;
                for (Fragment f : cc.getFragments()) {
                    String strreplace;
                    SourcePosition start = f.getStart();
                    SourcePosition end = f.getEnd();
                    int linecount = end.getLine() - start.getLine() + 1;
                    if (linecount < minimumlines) continue;
                    ++fragmentcountofclass;
                    de.uni_bremen.st.rcf.model.File startfile = start.getFile();
                    Directory startdirectory = startfile.getDirectory();
                    String strpath = startdirectory.getPath() + "\\" + startfile.getName();
                    strpath = strreplace = strpath.replaceAll("/", "\\\\");
                    String strstart = "\\";
                    if (!strpath.startsWith("\\")) {
                        strpath = strstart.concat(strpath);
                    }
                    String path = "<File>" + strpath + "</File>\r\n";
                    String line = "";
                    line = line + "<Start>" + start.getLine() + "</Start>\r\n";
                    line = line + "<End>" + end.getLine() + "</End>\r\n";
                    sb.append("<Clone>\r\n");
                    sb.append("<Fragment>\r\n");
                    sb.append(path);
                    sb.append(line);
                    sb.append("</Fragment>\r\n</Clone>\r\n");
                }
                if (fragmentcountofclass < 2) continue;
                sbGCFfile.append(sb.toString());
                sbGCFfile.append("</CloneClass>\r\n");
            }
            for (ClonePair cp : v.getClonePairs()) {
                String strreplace;
                Fragment fl = cp.getLeft();
                SourcePosition startleft = fl.getStart();
                SourcePosition endleft = fl.getEnd();
                int linecount1 = endleft.getLine() - startleft.getLine() + 1;
                Fragment fr = cp.getRight();
                SourcePosition startright = fr.getStart();
                SourcePosition endright = fr.getEnd();
                int linecountr = endright.getLine() - startright.getLine() + 1;
                if (linecount1 < minimumlines || linecountr < minimumlines) continue;
                int cloneClassID = cp.getId();
                sbGCFfile.append("<CloneClass>\r\n");
                sbGCFfile.append("<ID>");
                sbGCFfile.append(Integer.toString(cloneClassID));
                sbGCFfile.append("</ID>\r\n");
                de.uni_bremen.st.rcf.model.File startfile = startleft.getFile();
                Directory startdirectory = startfile.getDirectory();
                String strpath = startdirectory.getPath() + "\\" + startfile.getName();
                strpath = strreplace = strpath.replaceAll("/", "\\\\");
                String strstart = "\\";
                if (!strpath.startsWith("\\")) {
                    strpath = strstart.concat(strpath);
                }
                String path = "<File>" + strpath + "</File>\r\n";
                String line = "";
                line = line + "<Start>" + startleft.getLine() + "</Start>\r\n";
                line = line + "<End>" + endleft.getLine() + "</End>\r\n";
                sbGCFfile.append("<Clone>\r\n");
                sbGCFfile.append("<Fragment>\r\n");
                sbGCFfile.append(path);
                sbGCFfile.append(line);
                sbGCFfile.append("</Fragment>\r\n</Clone>\r\n");
                startfile = startright.getFile();
                startdirectory = startfile.getDirectory();
                strpath = startdirectory.getPath() + "\\" + startfile.getName();
                strpath = strreplace = strpath.replaceAll("/", "\\\\");
                strstart = "\\";
                if (!strpath.startsWith("\\")) {
                    strpath = strstart.concat(strpath);
                }
                path = "<File>" + strpath + "</File>\r\n";
                line = "";
                line = line + "<Start>" + startright.getLine() + "</Start>\r\n";
                line = line + "<End>" + endright.getLine() + "</End>\r\n";
                sbGCFfile.append("<Clone>\r\n");
                sbGCFfile.append("<Fragment>\r\n");
                sbGCFfile.append(path);
                sbGCFfile.append(line);
                sbGCFfile.append("</Fragment>\r\n</Clone>\r\n");
                sbGCFfile.append("</CloneClass>\r\n");
            }
            sbGCFfile.append("</CloneClasses>\r\n");
        }
        System.out.println(minimumlines);
        return sbGCFfile.toString();
    }
}

