/*
 * Decompiled with CFR 0.152.
 */
package fileconverters;

import fileconverters.Fileconverters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class FileConverterForConQAT
extends Fileconverters {
    @Override
    public String convert(File resultFile, ArrayList list) {
        ArrayList<String> filelist = new ArrayList<String>();
        ArrayList<String> clonelist = new ArrayList<String>();
        String basepath = (String)list.get(0);
        String filename = (String)list.get(1);
        String strminimumlines = (String)list.get(2);
        String output = "";
        int minimumlines = Integer.parseInt(strminimumlines.trim());
        FileConverterForConQAT.readConvertedFile(filename, filelist, clonelist, basepath);
        output = FileConverterForConQAT.converteToGCF(clonelist, filelist, minimumlines);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readConvertedFile(String filename, ArrayList<String> filelist, ArrayList<String> clonelist, String basepath) {
        BufferedReader infile = null;
        String filecontent = "";
        try {
            infile = new BufferedReader(new FileReader(filename));
            String inLine = infile.readLine();
            boolean firstLine = true;
            while (inLine != null) {
                if (inLine.trim().startsWith("<sourceFile")) {
                    String[] strsplitted = inLine.split("\"");
                    String[] strsplittedfurther = strsplitted[3].split(basepath, 2);
                    String strfile = strsplittedfurther[1];
                    String strreplaced = strfile.replaceAll("/", "\\\\");
                    filelist.add(strreplaced);
                } else {
                    clonelist.add(inLine);
                }
                inLine = infile.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        finally {
            try {
                if (infile != null) {
                    infile.close();
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
        return filecontent;
    }

    public static String converteToGCF(ArrayList<String> clonelist, ArrayList<String> filelist, int minimumlines) {
        StringBuffer sb = new StringBuffer();
        sb.append("<CloneClasses>\r\n");
        int minimum = 0;
        int fragmentnum = 0;
        int allclone = 0;
        int i = 0;
        while (i < clonelist.size()) {
            String strline = clonelist.get(i);
            if (strline.trim().startsWith("<cloneClass")) {
                boolean endcloneclass = false;
                String[] strsplitcloneclass = strline.split("\"");
                String strID = strsplitcloneclass[3];
                StringBuffer sbGCFfile = new StringBuffer();
                sbGCFfile.append("<CloneClass>\r\n");
                sbGCFfile.append("<ID>");
                sbGCFfile.append(strID);
                sbGCFfile.append("</ID>\r\n");
                int fragmentcountofclass = 0;
                ++i;
                while (!endcloneclass && i < clonelist.size()) {
                    strline = clonelist.get(i);
                    if (strline.trim().startsWith("<clone")) {
                        ++allclone;
                        String[] strsplitclone = strline.split("\"");
                        String strLinecount = strsplitclone[3];
                        int linecount = Integer.parseInt(strLinecount);
                        if (linecount >= minimumlines) {
                            ++fragmentnum;
                            ++fragmentcountofclass;
                            if (minimum == 0 || linecount < minimum) {
                                minimum = linecount;
                            }
                            String strstartline = strsplitclone[7];
                            int startline = Integer.parseInt(strstartline);
                            int endline = startline + linecount - 1;
                            String strendline = Integer.toString(endline);
                            String strfileID = strsplitclone[9];
                            int fileID = Integer.parseInt(strfileID);
                            String strfile = "";
                            if (fileID < filelist.size()) {
                                strfile = filelist.get(fileID);
                            }
                            sbGCFfile.append("<Clone>\r\n");
                            sbGCFfile.append("<Fragment>\r\n");
                            sbGCFfile.append("<File>");
                            sbGCFfile.append(strfile);
                            sbGCFfile.append("</File>\r\n");
                            sbGCFfile.append("<Start>");
                            sbGCFfile.append(strstartline);
                            sbGCFfile.append("</Start>\r\n");
                            sbGCFfile.append("<End>");
                            sbGCFfile.append(strendline);
                            sbGCFfile.append("</End>\r\n");
                            sbGCFfile.append("</Fragment>\r\n");
                            sbGCFfile.append("</Clone>\r\n");
                        }
                    }
                    if (strline.trim().startsWith("</cloneClass>")) {
                        endcloneclass = true;
                    }
                    ++i;
                }
                sbGCFfile.append("</CloneClass>\r\n");
                if (fragmentcountofclass < 2) continue;
                sb.append(sbGCFfile.toString());
                continue;
            }
            ++i;
        }
        sb.append("</CloneClasses>\r\n");
        System.out.println(minimum);
        return sb.toString();
    }
}

