/*
 * Decompiled with CFR 0.152.
 */
package fileconverters;

import fileconverters.Fileconverters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class FileConverterForCPD
extends Fileconverters {
    @Override
    public String convert(File resultFile, ArrayList list) {
        ArrayList<String> listline = new ArrayList<String>();
        String basepath = (String)list.get(0);
        String filename = (String)list.get(1);
        String output = "";
        FileConverterForCPD.readConvertedFile(filename, listline);
        if (list.size() == 2) {
            output = FileConverterForCPD.converteToGCF(listline, basepath);
        } else if (list.size() == 3) {
            String strminimumlines = (String)list.get(2);
            int minimumlines = Integer.parseInt(strminimumlines);
            output = FileConverterForCPD.converteToGCFmin(listline, basepath, minimumlines);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readConvertedFile(String filename, ArrayList<String> list) {
        BufferedReader infile = null;
        String filecontent = "";
        try {
            infile = new BufferedReader(new FileReader(filename));
            String inLine = infile.readLine();
            boolean firstLine = true;
            while (inLine != null) {
                list.add(inLine);
                inLine = infile.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        finally {
            try {
                if (infile != null) {
                    infile.close();
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
        return filecontent;
    }

    public static String converteToGCF(ArrayList<String> strlist, String basepath) {
        StringBuffer sbGCFfile = new StringBuffer();
        sbGCFfile.append("<CloneClasses>\r\n");
        int len = basepath.length();
        int cloneClassID = 0;
        int sum = 0;
        int tokenThreshold = 100;
        int numItem = 0;
        int minimum = 0;
        for (int i = 1; i < strlist.size(); ++i) {
            String[] splittedStrLine = strlist.get(i).split(",");
            if (splittedStrLine.length < 7) continue;
            sbGCFfile.append("<CloneClass>\r\n");
            sbGCFfile.append("<ID>");
            sbGCFfile.append(Integer.toString(++cloneClassID));
            sbGCFfile.append("</ID>\r\n");
            String strnumfragment = splittedStrLine[2];
            int numfragment = Integer.parseInt(strnumfragment);
            String strnumLine = splittedStrLine[0];
            int numLine = Integer.parseInt(strnumLine);
            String strnumToken = splittedStrLine[1];
            int numToken = Integer.parseInt(strnumToken);
            int lines = tokenThreshold * numLine / numToken;
            sum += lines;
            if (minimum == 0 || lines < minimum) {
                minimum = numLine;
            }
            ++numItem;
            int k = 2;
            for (int j = 1; j <= numfragment && 2 + j * 2 < splittedStrLine.length; ++j) {
                String strstartline = splittedStrLine[++k];
                int startline = Integer.parseInt(strstartline);
                int endline = startline + numLine - 1;
                String strendline = Integer.toString(endline);
                String strfiledir = splittedStrLine[++k];
                String strfile = strfiledir.substring(len);
                sbGCFfile.append("<Clone>\r\n");
                sbGCFfile.append("<Fragment>\r\n");
                sbGCFfile.append("<File>");
                String strreplaced = strfile.replaceAll("/", "\\\\");
                sbGCFfile.append(strreplaced);
                sbGCFfile.append("</File>\r\n");
                sbGCFfile.append("<Start>");
                sbGCFfile.append(strstartline);
                sbGCFfile.append("</Start>\r\n");
                sbGCFfile.append("<End>");
                sbGCFfile.append(strendline);
                sbGCFfile.append("</End>\r\n");
                sbGCFfile.append("</Fragment>\r\n");
                sbGCFfile.append("</Clone>\r\n");
            }
            sbGCFfile.append("</CloneClass>\r\n");
        }
        sbGCFfile.append("</CloneClasses>\r\n");
        if (numItem != 0) {
            System.out.println(minimum);
        }
        return sbGCFfile.toString();
    }

    public static String converteToGCFmin(ArrayList<String> strlist, String basepath, int minimumlines) {
        StringBuffer sbGCFfile = new StringBuffer();
        sbGCFfile.append("<CloneClasses>\r\n");
        String GCFfile = "";
        int len = basepath.length();
        int cloneClassID = 0;
        boolean sum = false;
        int tokenThreshold = 100;
        boolean minimum = false;
        for (int i = 1; i < strlist.size(); ++i) {
            String[] splittedStrLine = strlist.get(i).split(",");
            if (splittedStrLine.length < 7) continue;
            ++cloneClassID;
            StringBuffer sb = new StringBuffer();
            sb.append("<CloneClass>\r\n");
            sb.append("<ID>");
            sb.append(cloneClassID);
            sb.append("</ID>\r\n");
            int fragmentcountofclass = 0;
            String strnumfragment = splittedStrLine[2];
            int numfragment = Integer.parseInt(strnumfragment);
            String strnumLine = splittedStrLine[0];
            int numLine = Integer.parseInt(strnumLine);
            String strnumToken = splittedStrLine[1];
            int numToken = Integer.parseInt(strnumToken);
            int k = 2;
            for (int j = 1; j <= numfragment && 2 + j * 2 < splittedStrLine.length; ++j) {
                String strstartline = splittedStrLine[++k];
                int startline = Integer.parseInt(strstartline);
                int endline = startline + numLine - 1;
                String strendline = Integer.toString(endline);
                String strfiledir = splittedStrLine[++k];
                String strfile = strfiledir.substring(len);
                if (numLine < minimumlines) continue;
                ++fragmentcountofclass;
                sb.append("<Clone>\r\n");
                sb.append("<Fragment>\r\n");
                sb.append("<File>");
                String strreplaced = strfile.replaceAll("/", "\\\\");
                sb.append(strreplaced);
                sb.append("</File>\r\n");
                sb.append("<Start>");
                sb.append(strstartline);
                sb.append("</Start>\r\n");
                sb.append("<End>");
                sb.append(strendline);
                sb.append("</End>\r\n");
                sb.append("</Fragment>\r\n");
                sb.append("</Clone>\r\n");
            }
            if (fragmentcountofclass < 2) continue;
            sbGCFfile.append(sb.toString());
            sbGCFfile.append("</CloneClass>\r\n");
        }
        sbGCFfile.append("</CloneClasses>\r\n");
        System.out.println(minimumlines);
        return sbGCFfile.toString();
    }
}

