/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.scanner;

import edu.tum.cs.commons.filesystem.CanonicalFile;
import edu.tum.cs.scanner.ETokenType;
import edu.tum.cs.scanner.IToken;

public abstract class Token
implements IToken {
    protected final ETokenType type;
    protected final int offset;
    protected final int lineNumber;
    protected final String text;
    protected final CanonicalFile file;

    protected Token(ETokenType type, int offset, int lineNumber, String text, CanonicalFile file) {
        this.type = type;
        this.offset = offset;
        this.lineNumber = lineNumber;
        this.text = text;
        this.file = file;
    }

    public String toString() {
        String result = "TOKEN (" + (Object)((Object)this.type) + ") Text: >>" + this.text + "<<";
        result = result + " File: '" + this.file + "' line#: " + this.lineNumber;
        return result;
    }

    public String getText() {
        return this.text;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public CanonicalFile getFile() {
        return this.file;
    }

    public ETokenType getType() {
        return this.type;
    }
}

