/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.scanner;

import edu.tum.cs.scanner.ETokenType;
import edu.tum.cs.scanner.ILenientScanner;
import edu.tum.cs.scanner.IScanner;
import edu.tum.cs.scanner.IToken;
import edu.tum.cs.scanner.ScannerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScannerUtils {
    public static void readTokens(IScanner scanner, List<IToken> tokens, List<ScannerException> exceptions) throws IOException {
        IToken token = null;
        do {
            try {
                token = scanner.getNextToken();
                if (token.getType() == ETokenType.EOF) continue;
                tokens.add(token);
            }
            catch (ScannerException e) {
                exceptions.add(e);
            }
        } while (token != null && token.getType() != ETokenType.EOF);
    }

    public static List<IToken> readTokens(ILenientScanner scanner) throws IOException {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        IToken token = null;
        while ((token = scanner.getNextToken()).getType() != ETokenType.EOF) {
            tokens.add(token);
        }
        return tokens;
    }
}

