/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.scanner;

import edu.tum.cs.commons.filesystem.CanonicalFile;
import edu.tum.cs.scanner.ABAPScanner;
import edu.tum.cs.scanner.AdaScanner;
import edu.tum.cs.scanner.CPPScanner;
import edu.tum.cs.scanner.CSScanner;
import edu.tum.cs.scanner.CobolScanner;
import edu.tum.cs.scanner.ELanguage;
import edu.tum.cs.scanner.ILenientScanner;
import edu.tum.cs.scanner.IScanner;
import edu.tum.cs.scanner.JavaScanner;
import edu.tum.cs.scanner.PL1Scanner;
import edu.tum.cs.scanner.PLSQLScanner;
import edu.tum.cs.scanner.PythonScanner;
import edu.tum.cs.scanner.StrictScanner;
import edu.tum.cs.scanner.TSQLScanner;
import edu.tum.cs.scanner.TextScanner;
import edu.tum.cs.scanner.VBScanner;
import edu.tum.cs.scanner.XMLScanner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class ScannerFactory {
    private ScannerFactory() {
    }

    public static IScanner newScanner(ELanguage language, CanonicalFile file) throws FileNotFoundException {
        return ScannerFactory.strict(ScannerFactory.newLenientScanner(language, file));
    }

    public static IScanner newScanner(ELanguage language, File file) throws IOException {
        return ScannerFactory.strict(ScannerFactory.newLenientScanner(language, new CanonicalFile(file)));
    }

    public static ILenientScanner newLenientScanner(ELanguage language, CanonicalFile file) throws FileNotFoundException {
        return ScannerFactory.newLenientScanner(language, new FileReader(file), file);
    }

    public static ILenientScanner newLenientScanner(ELanguage language, File file) throws IOException {
        return ScannerFactory.newLenientScanner(language, new CanonicalFile(file));
    }

    public static IScanner newScanner(ELanguage language, String input, CanonicalFile file) {
        return ScannerFactory.strict(ScannerFactory.newLenientScanner(language, input, file));
    }

    public static ILenientScanner newLenientScanner(ELanguage language, String input, CanonicalFile file) {
        return ScannerFactory.newLenientScanner(language, new StringReader(input), file);
    }

    public static IScanner newScanner(ELanguage language, Reader reader, CanonicalFile file) {
        return ScannerFactory.strict(ScannerFactory.newLenientScanner(language, reader, file));
    }

    public static ILenientScanner newLenientScanner(ELanguage language, Reader reader, CanonicalFile file) {
        switch (language) {
            case JAVA: {
                return new JavaScanner(reader, file);
            }
            case CS: {
                return new CSScanner(reader, file);
            }
            case CPP: {
                return new CPPScanner(reader, file);
            }
            case VB: {
                return new VBScanner(reader, file);
            }
            case PL1: {
                return new PL1Scanner(reader, file);
            }
            case COBOL: {
                return new CobolScanner(reader, file);
            }
            case ABAP: {
                return new ABAPScanner(reader, file);
            }
            case ADA: {
                return new AdaScanner(reader, file);
            }
            case TEXT: {
                return new TextScanner(reader, file);
            }
            case XML: {
                return new XMLScanner(reader, file);
            }
            case PLSQL: {
                return new PLSQLScanner(reader, file);
            }
            case PYTHON: {
                return new PythonScanner(reader, file);
            }
            case TSQL: {
                return new TSQLScanner(reader, file);
            }
        }
        throw new IllegalArgumentException("Language '" + (Object)((Object)language) + "' not supported.");
    }

    public static IScanner strict(ILenientScanner scanner) {
        return new StrictScanner(scanner);
    }
}

