/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.scanner;

import edu.tum.cs.commons.assertion.CCSMAssert;
import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.filesystem.FileSystemUtils;
import edu.tum.cs.commons.string.StringUtils;
import edu.tum.cs.scanner.ELanguageConstants;
import edu.tum.cs.scanner.ETokenType;
import edu.tum.cs.scanner.IStatementOracle;
import edu.tum.cs.scanner.StatementOracle;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ELanguage {
    JAVA(CollectionUtils.asHashSet(ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE), ELanguageConstants.STANDARD_COMMENT_DELIMITERS, "java"),
    CPP(CollectionUtils.asHashSet(ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE), ELanguageConstants.STANDARD_COMMENT_DELIMITERS, "cpp", "cc", "c", "h", "hh", "hpp"),
    VB(CollectionUtils.asHashSet(ETokenType.COLON, ETokenType.EOL), CollectionUtils.asHashSet("'"), "vb", "frm", "cls", "bas"),
    PL1(CollectionUtils.asHashSet(ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE), ELanguageConstants.STANDARD_COMMENT_DELIMITERS, "pl1", "pli"),
    COBOL(CollectionUtils.asHashSet(ETokenType.DOT, ETokenType.EOL), CollectionUtils.asHashSet("/", "*"), "cbl", "cob", "cobol"),
    CS(CollectionUtils.asHashSet(ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.LBRACE), CollectionUtils.asHashSet("///", "//", "/*", "*/"), "cs"),
    ABAP(CollectionUtils.asHashSet(ETokenType.DOT), CollectionUtils.asHashSet("*", "\""), "abap"),
    ADA(CollectionUtils.asHashSet(ETokenType.SEMICOLON, ETokenType.THEN), CollectionUtils.asHashSet("--"), "ada", "ads", "adb"),
    TEXT(CollectionUtils.asHashSet(ETokenType.DOT, ETokenType.QUESTION, ETokenType.EXCLAMATION, ETokenType.COLON, ETokenType.COMMA, ETokenType.MULTIPLE_EOL), Collections.<String>emptySet(), "txt"),
    XML(CollectionUtils.asHashSet(ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.RIGHT_ANGLE_BRACKET), CollectionUtils.asHashSet("<!--", "-->"), "xml", "xsl", "xslt"),
    PLSQL(CollectionUtils.asHashSet(ETokenType.SEMICOLON), CollectionUtils.asHashSet("/*", "*/", "--"), "sql", "pks", "pkb"),
    PYTHON(CollectionUtils.asHashSet(ETokenType.EOL), CollectionUtils.asHashSet("#"), "py"),
    TSQL(CollectionUtils.asHashSet(ETokenType.EOL), CollectionUtils.asHashSet("/*", "*/", "--"), "tsql");

    private static HashMap<String, ELanguage> extension2LanguageMap;
    private final IStatementOracle statementOracle;
    private final String[] extensions;
    private Set<String> commentDelimiters;

    private ELanguage(Set<ETokenType> statementDelimiters, Set<String> commentDelimiters, String ... extensions) {
        this.statementOracle = new StatementOracle(statementDelimiters);
        this.commentDelimiters = commentDelimiters;
        this.extensions = extensions;
    }

    public String[] getFileExtensions() {
        return CollectionUtils.copyArray(this.extensions);
    }

    public IStatementOracle getStatementOracle() {
        return this.statementOracle;
    }

    public static ELanguage fromFileExtension(String path) {
        return ELanguage.fromFileExtension(new File(path));
    }

    public static ELanguage fromFileExtension(File file) {
        String extension = FileSystemUtils.getFileExtension(file);
        if (extension == null) {
            throw new IllegalArgumentException("Filename has no extension");
        }
        ELanguage result = extension2LanguageMap.get(extension.toLowerCase());
        if (result == null) {
            throw new IllegalArgumentException("Extension '" + extension + "' unknown");
        }
        return result;
    }

    public String getCommentContent(String commentText) {
        String[] lines;
        StringBuffer content = new StringBuffer();
        for (String line : lines = StringUtils.splitLines(commentText)) {
            if (content.length() > 0) {
                content.append(StringUtils.CR);
            }
            for (String delimiter : this.commentDelimiters) {
                line = line.trim();
                line = StringUtils.stripPrefix(delimiter, line);
                line = StringUtils.stripSuffix(delimiter, line);
                line = line.trim();
            }
            content.append(line);
        }
        return content.toString();
    }

    static {
        extension2LanguageMap = new HashMap();
        for (ELanguage language : ELanguage.values()) {
            for (String extension : language.extensions) {
                CCSMAssert.isFalse(extension2LanguageMap.containsKey(extension.toLowerCase()), "Duplicate extension " + extension);
                extension2LanguageMap.put(extension.toLowerCase(), language);
            }
        }
    }
}

