/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.xml;

import edu.tum.cs.commons.assertion.CCSMPre;
import edu.tum.cs.commons.string.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    private static final String ATTRIBUTE_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String SCHEMA_URL = "http://www.w3.org/2001/XMLSchema";
    private static final String ATTRIBUTE_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";

    public static Document parse(File file) throws SAXException, IOException {
        return XMLUtils.createSchemaUnawareParser().parse(file);
    }

    public static Document parse(InputSource input) throws SAXException, IOException {
        return XMLUtils.createSchemaUnawareParser().parse(input);
    }

    public static void parseSAX(File file, DefaultHandler handler) throws SAXException, IOException {
        XMLUtils.createSchemaUnawareSAXParser().parse(file, handler);
    }

    public static void parseSAX(InputSource input, DefaultHandler handler) throws SAXException, IOException {
        XMLUtils.createSchemaUnawareSAXParser().parse(input, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(File file, URL schemaURL) throws SAXException, IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            Document document = XMLUtils.parse(new InputSource(stream), schemaURL);
            return document;
        }
        finally {
            stream.close();
        }
    }

    public static Document parse(InputSource input, URL schemaURL) throws SAXException, IOException {
        CCSMPre.isTrue(schemaURL != null, "Schema URL may not be null!");
        DocumentBuilder parser = XMLUtils.createSchemaAwareParser(schemaURL);
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        parser.setErrorHandler(errorHandler);
        Document document = parser.parse(input);
        if (errorHandler.exception != null) {
            throw errorHandler.exception;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseSAX(File file, URL schemaURL, DefaultHandler handler) throws SAXException, IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            XMLUtils.parseSAX(new InputSource(stream), schemaURL, handler);
        }
        finally {
            stream.close();
        }
    }

    public static void parseSAX(InputSource input, URL schemaURL, DefaultHandler handler) throws SAXException, IOException {
        CCSMPre.isTrue(schemaURL != null, "Schema URL may not be null!");
        XMLUtils.createSchemaAwareSAXParser(schemaURL).parse(input, handler);
    }

    private static DocumentBuilder createSchemaUnawareParser() {
        try {
            return XMLUtils.createNamespaceAwareDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No document builder found, probably Java is misconfigured!", e);
        }
    }

    private static SAXParser createSchemaUnawareSAXParser() throws SAXException {
        try {
            return XMLUtils.createNamespaceAwareSAXParserFactory().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No SAX parser found, probably Java is misconfigured!", e);
        }
    }

    private static DocumentBuilder createSchemaAwareParser(URL schemaURL) {
        DocumentBuilderFactory dbf = XMLUtils.createNamespaceAwareDocumentBuilderFactory();
        dbf.setValidating(true);
        dbf.setAttribute(ATTRIBUTE_SCHEMA_LANGUAGE, SCHEMA_URL);
        dbf.setAttribute(ATTRIBUTE_SCHEMA_SOURCE, schemaURL.toString());
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No document builder found, probably Java is misconfigured!", e);
        }
    }

    private static SAXParser createSchemaAwareSAXParser(URL schemaURL) throws SAXException {
        SAXParserFactory spf = XMLUtils.createNamespaceAwareSAXParserFactory();
        spf.setValidating(true);
        try {
            SAXParser parser = spf.newSAXParser();
            parser.setProperty(ATTRIBUTE_SCHEMA_LANGUAGE, SCHEMA_URL);
            parser.setProperty(ATTRIBUTE_SCHEMA_SOURCE, schemaURL.toString());
            return parser;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No SAX parser found, probably Java is misconfigured!", e);
        }
    }

    private static DocumentBuilderFactory createNamespaceAwareDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf;
    }

    private static SAXParserFactory createNamespaceAwareSAXParserFactory() {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        return spf;
    }

    public static Document parse(File file, File schema) throws SAXException, IOException {
        try {
            return XMLUtils.parse(file, schema.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Schema file could not be converted to URL: " + e);
        }
    }

    public static String prettyPrint(Document doc) throws TransformerException {
        URL url = XMLUtils.class.getResource("pretty.xsl");
        StreamSource xslSource = new StreamSource(url.toExternalForm());
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
        DOMSource source = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return StringUtils.normalizeLineBreaks(writer.toString());
    }

    public static int getElementPosition(Element element) {
        int num = -1;
        for (Node node = element; node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            ++num;
        }
        return num;
    }

    public static List<Element> getNamedChildren(Element element, String elementNames) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(elementNames)) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static Element getNamedChild(Element element, String name) {
        List<Element> children = XMLUtils.getNamedChildren(element, name);
        if (children.size() > 0) {
            return children.get(0);
        }
        return null;
    }

    public static String getNamedChildContent(Element parent, String name) {
        Element element = XMLUtils.getNamedChild(parent, name);
        if (element == null) {
            return "";
        }
        return element.getTextContent();
    }

    public static List<Element> elementNodes(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static List<Element> leafElementNodes(Element root) {
        ArrayList<Element> leafElementNodes = new ArrayList<Element>();
        XMLUtils.leafElementNodes(root, leafElementNodes);
        return leafElementNodes;
    }

    private static void leafElementNodes(Element root, List<Element> leafElementNodes) {
        List<Element> children = XMLUtils.elementNodes(root.getChildNodes());
        if (children.isEmpty()) {
            leafElementNodes.add(root);
        } else {
            for (Element child : children) {
                XMLUtils.leafElementNodes(child, leafElementNodes);
            }
        }
    }

    public static Document createEmptyDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No document builder found, probably Java is misconfigured!", e);
        }
        return builder.newDocument();
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private SAXParseException exception;

        private XMLErrorHandler() {
        }

        public void error(SAXParseException exception) {
            if (this.exception == null) {
                this.exception = exception;
            }
        }

        public void fatalError(SAXParseException exception) {
            this.error(exception);
        }

        public void warning(SAXParseException exception) {
            System.out.println(exception);
        }
    }
}

