/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.xml;

import edu.tum.cs.commons.assertion.CCSMPre;
import edu.tum.cs.commons.xml.IXMLElementProcessor;
import edu.tum.cs.commons.xml.IXMLResolver;
import edu.tum.cs.commons.xml.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLReader<E extends Enum<E>, A extends Enum<A>, X extends Exception> {
    private Element currentDOMElement;
    private final URL schemaURL;
    private final IXMLResolver<E, A> xmlResolver;
    private final File file;
    private final String encoding;

    public XMLReader(File file, IXMLResolver<E, A> xmlResolver) {
        this(file, null, null, xmlResolver);
    }

    public XMLReader(File file, String encoding, IXMLResolver<E, A> xmlResolver) {
        this(file, encoding, null, xmlResolver);
    }

    public XMLReader(File file, URL schemaURL, IXMLResolver<E, A> xmlResolver) {
        this(file, null, schemaURL, xmlResolver);
    }

    public XMLReader(File file, String encoding, URL schemaURL, IXMLResolver<E, A> xmlResolver) {
        CCSMPre.isFalse(file == null, "File may not be null.");
        CCSMPre.isFalse(xmlResolver == null, "XML resolver may not be null.");
        this.file = file;
        this.encoding = encoding;
        this.schemaURL = schemaURL;
        this.xmlResolver = xmlResolver;
    }

    protected boolean getBooleanAttribute(A attribute) {
        String value = this.getStringAttribute(attribute);
        return Boolean.valueOf(value);
    }

    protected String getChildText(E childElement) {
        Element domElement = this.getChildElement(childElement);
        if (domElement == null) {
            return null;
        }
        return domElement.getTextContent();
    }

    protected <T extends Enum<T>> T getEnumAttribute(A attribute, Class<T> enumClass) {
        String value = this.getStringAttribute(attribute);
        return Enum.valueOf(enumClass, value);
    }

    protected int getIntAttribute(A attribute) {
        String value = this.getStringAttribute(attribute);
        return Integer.valueOf(value);
    }

    protected long getLongAttribute(A attribute) {
        String value = this.getStringAttribute(attribute);
        return Long.valueOf(value);
    }

    protected String getStringAttribute(A attribute) {
        return this.currentDOMElement.getAttribute(this.xmlResolver.resolveAttributeName(attribute));
    }

    protected String getText() {
        return this.currentDOMElement.getTextContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile() throws SAXException, IOException {
        FileInputStream stream = new FileInputStream(this.file);
        try {
            InputSource input = new InputSource(stream);
            if (this.encoding != null) {
                input.setEncoding(this.encoding);
            }
            Document document = this.schemaURL == null ? XMLUtils.parse(input) : XMLUtils.parse(input, this.schemaURL);
            this.currentDOMElement = document.getDocumentElement();
        }
        finally {
            stream.close();
        }
    }

    protected void processChildElements(IXMLElementProcessor<E, X> processor) throws X {
        String targetElementName = this.xmlResolver.resolveElementName(processor.getTargetElement());
        this.processElementList(processor, this.getChildElements(targetElementName));
    }

    protected void processDecendantElements(IXMLElementProcessor<E, X> processor) throws X {
        String targetElementName = this.xmlResolver.resolveElementName(processor.getTargetElement());
        NodeList descendantNodes = this.currentDOMElement.getElementsByTagName(targetElementName);
        this.processElementList(processor, XMLUtils.elementNodes(descendantNodes));
    }

    private void processElementList(IXMLElementProcessor<E, X> processor, List<Element> elements) throws X {
        Element oldElement = this.currentDOMElement;
        Iterator<Element> i$ = elements.iterator();
        while (i$.hasNext()) {
            Element child;
            this.currentDOMElement = child = i$.next();
            processor.process();
        }
        this.currentDOMElement = oldElement;
    }

    private Element getChildElement(E elementType) {
        NodeList nodeList = this.currentDOMElement.getChildNodes();
        String elementName = this.xmlResolver.resolveElementName(elementType);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!this.isTargetElement(child, elementName)) continue;
            return (Element)child;
        }
        return null;
    }

    private List<Element> getChildElements(String targetElementName) {
        NodeList nodeList = this.currentDOMElement.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!this.isTargetElement(child, targetElementName)) continue;
            list.add((Element)nodeList.item(i));
        }
        return list;
    }

    private boolean isTargetElement(Node child, String targetElementName) {
        return child.getNodeType() == 1 && child.getLocalName().equals(targetElementName);
    }
}

