/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.version;

import edu.tum.cs.commons.error.FormatException;
import edu.tum.cs.commons.filesystem.FileSystemUtils;
import edu.tum.cs.commons.version.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class VersionUtils {
    public static void checkForNewVersion(final String appName, String versionFileUrl, Version runningVersion) {
        Version currentVersion;
        try {
            currentVersion = VersionUtils.getMostRecentVersion(versionFileUrl);
        }
        catch (Exception e) {
            return;
        }
        if (currentVersion.compareTo(runningVersion) > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(null, "The newer version " + currentVersion + " of " + appName + " is available for download!", "Update available", 1);
                }
            });
        }
    }

    public static Version getMostRecentVersion(String versionFileUrl) throws IOException, FormatException {
        URL versionURL = new URL(versionFileUrl);
        InputStream in = versionURL.openStream();
        String versionString = FileSystemUtils.readStream(in);
        in.close();
        return Version.parseVersion(versionString);
    }
}

