/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.tree;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.collections.UnmodifiableCollection;
import edu.tum.cs.commons.string.StringUtils;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTreeNode<K> {
    private final HashMap<K, SimpleTreeNode<K>> children = new HashMap();
    private final K key;

    public SimpleTreeNode(K key) {
        this.key = key;
    }

    public SimpleTreeNode<K> getChild(K key) {
        return this.children.get(key);
    }

    public void addChild(SimpleTreeNode<K> child) {
        this.children.put(child.getKey(), child);
    }

    public K getKey() {
        return this.key;
    }

    public UnmodifiableCollection<SimpleTreeNode<K>> getChildren() {
        return CollectionUtils.asUnmodifiable(this.children.values());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.key + StringUtils.CR);
        for (SimpleTreeNode<K> child : this.children.values()) {
            result.append(StringUtils.prefixLines(child.toString(), "  ", true));
            result.append(StringUtils.CR);
        }
        return result.toString();
    }
}

