/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.test;

import edu.tum.cs.commons.filesystem.CanonicalFile;
import edu.tum.cs.commons.filesystem.FileSystemUtils;
import edu.tum.cs.commons.test.TestDataManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import junit.framework.TestCase;

public abstract class CCSMTestCaseBase
extends TestCase {
    private static final File TEST_DATA_ROOT_DIRECTORY = new File("test-data");
    private static final File TEST_TMP_ROOT_DIRECTORY = new File("test-tmp");
    private final TestDataManager testDataManager = TestDataManager.getInstance(new File(TEST_DATA_ROOT_DIRECTORY, ((Object)((Object)this)).getClass().getPackage().getName()));
    private final File tmpDirectory = new File(TEST_TMP_ROOT_DIRECTORY, ((Object)((Object)this)).getClass().getPackage().getName());

    public CCSMTestCaseBase() {
    }

    public CCSMTestCaseBase(String name) {
        super(name);
    }

    protected File useTestFile(String filename) {
        return this.testDataManager.getTestFile(filename, this);
    }

    protected File createTmpFile(String filename, String content) throws IOException {
        File file = new File(this.tmpDirectory, filename);
        FileSystemUtils.writeFile(file, content);
        return file;
    }

    protected File getTmpDirectory() {
        return this.tmpDirectory;
    }

    protected void deleteTmpDirectory() {
        if (this.tmpDirectory.isDirectory()) {
            FileSystemUtils.deleteRecursively(this.tmpDirectory);
        }
    }

    protected void printUsedFiles() {
        this.testDataManager.printUsedFiles(new PrintWriter(System.out));
    }

    protected void printUnusedFiles() {
        this.testDataManager.printUnusedFiles(new PrintWriter(System.out));
    }

    protected void printStatistics() {
        this.printUsedFiles();
        this.printUnusedFiles();
    }

    protected CanonicalFile useCanonicalTestFile(String filename) {
        try {
            return new CanonicalFile(this.useTestFile(filename));
        }
        catch (IOException e) {
            CCSMTestCaseBase.fail((String)("Problem canonizing file: " + filename + ": " + e.getMessage()));
            return null;
        }
    }

    protected CanonicalFile createCanonicalTmpFile(String filename, String content) throws IOException {
        return this.canonize(this.createTmpFile(filename, content));
    }

    protected CanonicalFile canonize(File file) {
        try {
            return new CanonicalFile(file);
        }
        catch (IOException e) {
            CCSMTestCaseBase.fail((String)("Problem canonizing file: " + file + ": " + e.getMessage()));
            return null;
        }
    }

    public static boolean is64BitVM() {
        return System.getProperty("os.arch").contains("64");
    }
}

