/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.reflect;

import edu.tum.cs.commons.assertion.CCSMPre;
import edu.tum.cs.commons.enums.EnumUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EJavaPrimitive {
    VOID(Void.TYPE, Void.class),
    BYTE(Byte.TYPE, Byte.class),
    CHAR(Character.TYPE, Character.class),
    DOUBLE(Double.TYPE, Double.class),
    FLOAT(Float.TYPE, Float.class),
    INT(Integer.TYPE, Integer.class),
    LONG(Long.TYPE, Long.class),
    SHORT(Short.TYPE, Short.class),
    BOOLEAN(Boolean.TYPE, Boolean.class);

    private final Class<?> primitiveClass;
    private final Class<?> wrapperClass;

    private EJavaPrimitive(Class<?> primitiveClass, Class<?> wrapperClass) {
        CCSMPre.isTrue(primitiveClass.isPrimitive(), "Clazz object must be a primitive.");
        this.primitiveClass = primitiveClass;
        this.wrapperClass = wrapperClass;
    }

    public Class<?> getClassObject() {
        return this.primitiveClass;
    }

    public Class<?> getWrapperClass() {
        return this.wrapperClass;
    }

    public static EJavaPrimitive getPrimitive(String name) {
        return EnumUtils.valueOf(EJavaPrimitive.class, name);
    }

    public static EJavaPrimitive getPrimitiveIgnoreCase(String name) {
        return EnumUtils.valueOfIgnoreCase(EJavaPrimitive.class, name);
    }

    public static EJavaPrimitive getForPrimitiveClass(Class<?> clazz) {
        for (EJavaPrimitive javaPrimitive : EJavaPrimitive.values()) {
            if (!javaPrimitive.primitiveClass.equals(clazz)) continue;
            return javaPrimitive;
        }
        return null;
    }

    public static EJavaPrimitive getForWrapperClass(Class<?> clazz) {
        for (EJavaPrimitive javaPrimitive : EJavaPrimitive.values()) {
            if (!javaPrimitive.wrapperClass.equals(clazz)) continue;
            return javaPrimitive;
        }
        return null;
    }

    public static EJavaPrimitive getForPrimitiveOrWrapperClass(Class<?> clazz) {
        for (EJavaPrimitive javaPrimitive : EJavaPrimitive.values()) {
            if (!javaPrimitive.primitiveClass.equals(clazz) && !javaPrimitive.wrapperClass.equals(clazz)) continue;
            return javaPrimitive;
        }
        return null;
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return EJavaPrimitive.getForWrapperClass(clazz) != null;
    }
}

