/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.reflect;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.collections.UnmodifiableSet;
import edu.tum.cs.commons.reflect.ReflectionUtils;
import edu.tum.cs.commons.reflect.TypesNotMergableException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassType {
    private Class<?> baseClass = Object.class;
    private Set<Class<?>> interfaces = new HashSet();

    public ClassType() {
    }

    private ClassType(ClassType c) {
        this.baseClass = c.baseClass;
        this.interfaces.addAll(c.interfaces);
    }

    public ClassType(Class<?> clazz) {
        if (clazz.isInterface()) {
            this.interfaces.add(clazz);
            this.normalizeInterfaces();
        } else {
            this.baseClass = ReflectionUtils.resolvePrimitiveClass(clazz);
        }
    }

    public ClassType(Class<?> ... classes) throws TypesNotMergableException {
        for (Class<?> c : classes) {
            this.mergeInClass(ReflectionUtils.resolvePrimitiveClass(c));
        }
        this.normalizeInterfaces();
    }

    private void normalizeInterfaces() {
        Set<Class<?>> oldInterfaces = this.interfaces;
        this.interfaces = new HashSet();
        for (Class<?> iface : oldInterfaces) {
            if (iface.isAssignableFrom(this.baseClass)) continue;
            boolean isCovered = false;
            for (Class<?> otherIface : oldInterfaces) {
                if (iface == otherIface || !iface.isAssignableFrom(otherIface)) continue;
                isCovered = true;
                break;
            }
            if (isCovered) continue;
            this.interfaces.add(iface);
        }
    }

    public ClassType merge(ClassType classType) throws TypesNotMergableException {
        ClassType result = new ClassType(this);
        result.interfaces.addAll(classType.interfaces);
        result.mergeInClass(classType.baseClass);
        result.normalizeInterfaces();
        return result;
    }

    private void mergeInClass(Class<?> c) throws TypesNotMergableException {
        if (c.isInterface()) {
            this.interfaces.add(c);
        } else if (!this.baseClass.equals(c) && !ReflectionUtils.isAssignable(this.baseClass, c)) {
            if (ReflectionUtils.isAssignable(c, this.baseClass)) {
                this.baseClass = c;
            } else {
                throw new TypesNotMergableException("Types " + c + " and " + this.baseClass + " could not be merged!");
            }
        }
    }

    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    public boolean hasInterfaces() {
        return !this.interfaces.isEmpty();
    }

    public UnmodifiableSet<Class<?>> getInterfaces() {
        return CollectionUtils.asUnmodifiable(this.interfaces);
    }

    public boolean isAssignableFrom(ClassType classType) {
        if (!this.baseClass.isAssignableFrom(classType.baseClass)) {
            return false;
        }
        for (Class<?> iface : this.interfaces) {
            if (classType.implementsInterface(iface)) continue;
            return false;
        }
        return true;
    }

    public boolean implementsInterface(Class<?> requiredInterface) {
        if (requiredInterface.isAssignableFrom(this.baseClass)) {
            return true;
        }
        for (Class<?> iface : this.interfaces) {
            if (!requiredInterface.isAssignableFrom(iface)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.interfaces.size() == 1 && this.baseClass.equals(Object.class)) {
            return this.interfaces.iterator().next().getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseClass.getName());
        if (!this.interfaces.isEmpty()) {
            String sep = " ";
            sb.append(" implements");
            for (Class<?> iface : this.interfaces) {
                sb.append(sep);
                sep = ", ";
                sb.append(iface.getName());
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassType)) {
            return false;
        }
        ClassType ct = (ClassType)obj;
        if (!ct.baseClass.equals(this.baseClass)) {
            return false;
        }
        if (ct.interfaces.size() != this.interfaces.size()) {
            return false;
        }
        for (Class<?> iface : ct.interfaces) {
            if (this.interfaces.contains(iface)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (Class<?> iface : this.interfaces) {
            result *= iface.hashCode();
        }
        return 13 * result * this.baseClass.hashCode();
    }
}

