/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.options;

import edu.tum.cs.commons.options.AOption;
import edu.tum.cs.commons.options.AOptionComparator;
import edu.tum.cs.commons.options.CommandLineTokenStream;
import edu.tum.cs.commons.options.OptionApplicator;
import edu.tum.cs.commons.options.OptionException;
import edu.tum.cs.commons.options.OptionRegistry;
import edu.tum.cs.commons.reflect.TypeConversionException;
import edu.tum.cs.commons.string.StringUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class CommandLine {
    private final OptionRegistry registry;

    public CommandLine(OptionRegistry registry) {
        this.registry = registry;
    }

    public String[] parse(String[] args) throws OptionException {
        return this.parse(new CommandLineTokenStream(args));
    }

    public String[] parse(CommandLineTokenStream ts) throws OptionException {
        ArrayList<String> fileArgs = new ArrayList<String>();
        while (ts.hasNext()) {
            OptionApplicator applicator;
            if (ts.nextIsLongOption()) {
                String name = ts.nextLongOption();
                applicator = this.registry.getLongOption(name);
                this.applyOption(applicator, this.formatLongOption(name), ts);
                continue;
            }
            if (ts.nextIsShortOption()) {
                char name = ts.nextShortOption();
                applicator = this.registry.getShortOption(name);
                this.applyOption(applicator, this.formatShortOption(name), ts);
                continue;
            }
            if (ts.nextIsFileArgument()) {
                fileArgs.add(ts.next());
                continue;
            }
            throw new OptionException("Unexpected command line argument: " + ts.next());
        }
        String[] result = new String[fileArgs.size()];
        return fileArgs.toArray(result);
    }

    private void applyOption(OptionApplicator applicator, String optionName, CommandLineTokenStream ts) throws OptionException {
        if (applicator == null) {
            throw new OptionException("Unknown option: " + optionName);
        }
        if (applicator.requiresParameter()) {
            if (!ts.nextIsParameter()) {
                throw new OptionException("Missing argument for option: " + optionName);
            }
            do {
                String parameter = ts.next();
                try {
                    applicator.applyOption(parameter);
                }
                catch (TypeConversionException e) {
                    throw new OptionException("Parameter " + parameter + " for option " + optionName + " is not of required type!");
                }
            } while (applicator.isGreedy() && ts.hasNext() && !ts.nextIsLongOption() && !ts.nextIsShortOption());
        } else {
            applicator.applyOption();
        }
    }

    public void printUsage(PrintWriter pw) {
        this.printUsage(pw, 20, 80);
    }

    public void printUsage(PrintWriter pw, int firstCol, int width) {
        ArrayList<AOption> sortedOptions = new ArrayList<AOption>(this.registry.getAllOptions());
        Collections.sort(sortedOptions, new AOptionComparator());
        for (AOption option : sortedOptions) {
            this.printOption(option, pw, firstCol, width);
        }
        pw.flush();
    }

    private void printOption(AOption option, PrintWriter pw, int firstCol, int width) {
        String[] words;
        String names = this.formatNames(option);
        pw.print(names);
        int pos = names.length();
        if (pos > firstCol) {
            pos = width + 1;
        } else {
            pw.print(StringUtils.fillString(firstCol - pos, ' '));
        }
        String indent = StringUtils.fillString(firstCol, ' ');
        for (String word : words = option.description().split("\\s+")) {
            if (pos + 1 + word.length() > width) {
                pw.println();
                pw.print(indent);
                pos = firstCol;
            }
            pw.print(' ');
            pw.print(word);
            pos += 1 + word.length();
        }
        pw.println();
    }

    private String formatNames(AOption option) {
        String names = "  ";
        if (option.shortName() == '\u0000') {
            names = names + StringUtils.fillString(2 + this.formatShortOption('x').length(), ' ');
        } else {
            names = names + this.formatShortOption(option.shortName());
            if (option.longName().length() > 0) {
                names = names + ", ";
            }
        }
        if (option.longName().length() > 0) {
            names = names + this.formatLongOption(option.longName());
        }
        return names;
    }

    private String formatLongOption(String name) {
        return "--" + name;
    }

    private String formatShortOption(char name) {
        return "-" + name;
    }
}

