/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.filesystem;

import edu.tum.cs.commons.assertion.CCSMAssert;
import edu.tum.cs.commons.collections.ArrayUtils;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EByteOrderMark {
    UTF_32BE("UTF-32BE", new byte[]{0, 0, -2, -1}),
    UTF_32LE("UTF-32LE", new byte[]{-1, -2, 0, 0}),
    UTF_16BE("UTF-16BE", new byte[]{-2, -1}),
    UTF_16LE("UTF-16LE", new byte[]{-1, -2}),
    UTF_8_BOM("UTF-8", new byte[]{-17, -69, -65});

    public static final int MAX_BOM_LENGTH = 4;
    private final String encoding;
    private final byte[] bom;

    private EByteOrderMark(String encoding, byte[] bom) {
        this.encoding = encoding;
        CCSMAssert.isTrue(bom.length <= 4, "Inconsistent max BOM length!");
        this.bom = bom;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getBOM() {
        return Arrays.copyOf(this.bom, this.bom.length);
    }

    public int getBOMLength() {
        return this.bom.length;
    }

    public static EByteOrderMark determineBOM(byte[] data) {
        for (EByteOrderMark bom : EByteOrderMark.values()) {
            if (!ArrayUtils.isPrefix(bom.bom, data)) continue;
            return bom;
        }
        return null;
    }
}

