/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.enums;

import edu.tum.cs.commons.assertion.CCSMAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumUtils {
    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String constantName) {
        try {
            T constant = Enum.valueOf(enumType, constantName);
            return constant;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <T extends Enum<T>> T valueOfIgnoreCase(Class<T> enumType, String constantName) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        CCSMAssert.isNotNull(constants);
        for (Enum constant : constants) {
            if (!constant.name().equalsIgnoreCase(constantName)) continue;
            return (T)constant;
        }
        return null;
    }

    public static <T extends Enum<T>> String[] stringValues(Class<T> enumType) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        CCSMAssert.isNotNull(constants);
        String[] result = new String[constants.length];
        for (int i = 0; i < constants.length; ++i) {
            result[i] = constants[i].name();
        }
        return result;
    }
}

