/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.collections;

import edu.tum.cs.commons.reflect.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHierarchyMap<T, V> {
    private final HashMap<Class<? extends T>, V> map = new HashMap();

    public void clear() {
        this.map.clear();
    }

    public V get(Class<?> key) {
        V value = this.map.get(key);
        if (value != null) {
            return value;
        }
        List<Class<?>> superClasses = ReflectionUtils.getSuperClasses(key);
        for (Class<?> clazz : superClasses) {
            value = this.map.get(clazz);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public V get(T element) {
        return this.get((T)element.getClass());
    }

    public List<V> getAll(Class<?> key) {
        ArrayList<V> list = new ArrayList<V>();
        List<Class<?>> classes = ReflectionUtils.getSuperClasses(key);
        classes.add(0, key);
        for (Class<?> clazz : classes) {
            V value = this.map.get(clazz);
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public List<V> getAll(T element) {
        return this.getAll((T)element.getClass());
    }

    public V getDeclared(Class<?> key) {
        return this.map.get(key);
    }

    public V getDeclared(T element) {
        return this.getDeclared((T)element.getClass());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<Class<? extends T>> keySet() {
        return this.map.keySet();
    }

    public V put(Class<? extends T> key, V value) {
        return this.map.put(key, value);
    }

    public V remove(Class<?> key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Collection<V> values() {
        return this.map.values();
    }
}

