/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.clone;

import edu.tum.cs.commons.clone.DeepCloneException;
import edu.tum.cs.commons.clone.IDeepCloneable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneUtils {
    public static void cloneMapEntries(Map<String, Object> source, Map<String, Object> target) throws DeepCloneException {
        for (String key : source.keySet()) {
            target.put(key, CloneUtils.cloneAsDeepAsPossible(source.get(key)));
        }
    }

    public static Object cloneAsDeepAsPossible(Object o) throws DeepCloneException {
        return CloneUtils.cloneAsDeepAsPossible(o, 3);
    }

    public static Object cloneAsDeepAsPossible(Object o, int maxDepth) throws DeepCloneException {
        if (maxDepth < 0) {
            throw new DeepCloneException("Reached maximal allowed cloning depth.");
        }
        --maxDepth;
        try {
            Method clone;
            if (o == null) {
                return null;
            }
            if (o instanceof IDeepCloneable) {
                return ((IDeepCloneable)o).deepClone();
            }
            if (o instanceof Map) {
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                Iterator i$ = ((Map)o).entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry child;
                    Map.Entry entry = child = i$.next();
                    result.put(CloneUtils.cloneAsDeepAsPossible(entry.getKey(), maxDepth), CloneUtils.cloneAsDeepAsPossible(entry.getValue(), maxDepth));
                }
                return result;
            }
            if (o instanceof Object[]) {
                Object[] result = (Object[])((Object[])o).clone();
                for (int i = 0; i < result.length; ++i) {
                    result[i] = CloneUtils.cloneAsDeepAsPossible(result[i], maxDepth);
                }
                return result;
            }
            if (o instanceof Collection) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object child : (Collection)o) {
                    result.add(CloneUtils.cloneAsDeepAsPossible(child, maxDepth));
                }
                return result;
            }
            if (o instanceof Cloneable && Modifier.isPublic((clone = o.getClass().getMethod("clone", new Class[0])).getModifiers())) {
                return clone.invoke(o, new Object[0]);
            }
            return o;
        }
        catch (DeepCloneException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DeepCloneException(ex);
        }
    }
}

