/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.assessment;

import edu.tum.cs.commons.assessment.ETrafficLightColor;
import edu.tum.cs.commons.clone.IDeepCloneable;
import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assessment
implements Cloneable,
IDeepCloneable,
Serializable {
    private int[] mapping = new int[ETrafficLightColor.values().length];
    private String message;

    public Assessment() {
    }

    public Assessment(ETrafficLightColor color) {
        this.add(color);
    }

    public Assessment(ETrafficLightColor color, String message) {
        this.add(color);
        this.message = message;
    }

    public void add(ETrafficLightColor color) {
        int n = color.ordinal();
        this.mapping[n] = this.mapping[n] + 1;
    }

    public void add(ETrafficLightColor color, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be non-negative!");
        }
        int n = color.ordinal();
        this.mapping[n] = this.mapping[n] + count;
    }

    public void add(Assessment a) {
        for (int i = 0; i < this.mapping.length; ++i) {
            int n = i;
            this.mapping[n] = this.mapping[n] + a.mapping[i];
        }
    }

    public int getColorFrequency(ETrafficLightColor color) {
        return this.mapping[color.ordinal()];
    }

    public ETrafficLightColor getDominantColor() {
        for (int i = 0; i < ETrafficLightColor.values().length; ++i) {
            if (this.mapping[i] <= 0) continue;
            return ETrafficLightColor.values()[i];
        }
        return ETrafficLightColor.UNKNOWN;
    }

    public ETrafficLightColor getMostFrequentColor() {
        ETrafficLightColor result = null;
        int resultCount = 0;
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i] <= resultCount) continue;
            resultCount = this.mapping[i];
            result = ETrafficLightColor.values()[i];
        }
        if (result != null) {
            return result;
        }
        return ETrafficLightColor.UNKNOWN;
    }

    public String toString() {
        int i;
        int sum = 0;
        for (i = 0; i < this.mapping.length; ++i) {
            sum += this.mapping[i];
        }
        if (sum == 0) {
            return "";
        }
        if (sum == 1) {
            for (i = 0; i < this.mapping.length; ++i) {
                if (this.mapping[i] <= 0) continue;
                return ETrafficLightColor.values()[i].toString();
            }
        }
        StringBuilder builder = new StringBuilder("[");
        this.appendColor(builder, ETrafficLightColor.GREEN);
        builder.append(", ");
        this.appendColor(builder, ETrafficLightColor.YELLOW);
        builder.append(", ");
        this.appendColor(builder, ETrafficLightColor.RED);
        builder.append("]");
        return builder.toString();
    }

    private void appendColor(StringBuilder builder, ETrafficLightColor color) {
        builder.append(color.toString().substring(0, 1));
        builder.append(": ");
        builder.append(this.getColorFrequency(color));
    }

    protected Object clone() throws CloneNotSupportedException {
        Assessment a = (Assessment)super.clone();
        a.mapping = (int[])a.mapping.clone();
        return a;
    }

    @Override
    public Assessment deepClone() {
        Assessment a = new Assessment();
        a.add(this);
        return a;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Assessment)) {
            return false;
        }
        Assessment a = (Assessment)obj;
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i] == a.mapping[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.mapping.length; ++i) {
            hash *= 97;
            hash += this.mapping[i];
            hash %= 0x3000005;
        }
        return hash;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static Assessment aggregate(Collection<Assessment> values) {
        Assessment result = new Assessment();
        for (Assessment a : values) {
            result.add(a);
        }
        return result;
    }
}

