/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.algo;

import edu.tum.cs.commons.assertion.CCSMPre;
import edu.tum.cs.commons.string.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff<T> {
    private final List<T> a;
    private final List<T> b;
    private final int n;
    private final int m;
    private final int max;
    private final int[][] v;
    private final boolean[][] from;

    private Diff(List<T> a, List<T> b) {
        this.a = a;
        this.b = b;
        this.n = a.size();
        this.m = b.size();
        this.max = this.n + this.m;
        this.v = new int[this.max + 1][];
        this.from = new boolean[this.max + 1][];
    }

    private Delta<T> computeDelta() {
        return this.constructDelta(this.calculateDeltaSize());
    }

    private Delta<T> constructDelta(int size) {
        int d = size;
        int k = -size;
        while (this.v[size][size + k] < this.n || this.v[size][d + k] - k < this.m) {
            ++k;
        }
        Delta delta = new Delta(size, this.n, this.m);
        int difference = this.n - this.m;
        while (d > 0) {
            k = this.from[d][d + k] ? ++k : --k;
            int x = this.v[d][--d + k];
            int y = x - k;
            int newDifference = x - y;
            if (newDifference > difference) {
                delta.position[d] = y + 1;
                delta.t[d] = this.b.get(y);
            } else {
                delta.position[d] = -x - 1;
                delta.t[d] = this.a.get(x);
            }
            difference = newDifference;
        }
        return delta;
    }

    private int calculateDeltaSize() {
        int size = -1;
        for (int d = 0; size < 0 && d <= this.max; ++d) {
            this.v[d] = new int[2 * d + 1];
            this.from[d] = new boolean[2 * d + 1];
            for (int k = -d; k <= d; k += 2) {
                int y;
                int x = 0;
                if (d > 0) {
                    if (k == -d || k != d && this.v[d - 1][d - 1 + k - 1] < this.v[d - 1][d - 1 + k + 1]) {
                        x = this.v[d - 1][d - 1 + k + 1];
                        this.from[d][d + k] = true;
                    } else {
                        x = this.v[d - 1][d - 1 + k - 1] + 1;
                        this.from[d][d + k] = false;
                    }
                }
                for (y = x - k; x < this.n && y < this.m && this.a.get(x).equals(this.b.get(y)); ++x, ++y) {
                }
                this.v[d][d + k] = x;
                if (x < this.n || y < this.m) continue;
                size = d;
            }
        }
        return size;
    }

    public static <T> Delta<T> computeDelta(T[] a, T[] b) {
        return Diff.computeDelta(Arrays.asList(a), Arrays.asList(b));
    }

    public static <T> Delta<T> computeDelta(List<T> a, List<T> b) {
        return super.computeDelta();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Delta<T> {
        private final int n;
        private final int m;
        private final int[] position;
        private final T[] t;

        private Delta(int size, int n, int m) {
            this.n = n;
            this.m = m;
            this.position = new int[size];
            this.t = new Object[size];
        }

        public int getSize() {
            return this.position.length;
        }

        public int getN() {
            return this.n;
        }

        public int getM() {
            return this.m;
        }

        public T getT(int i) {
            return this.t[i];
        }

        public int getPosition(int i) {
            return this.position[i];
        }

        public List<T> forwardPatch(List<T> a) {
            CCSMPre.isTrue(a.size() == this.n, "Input word must be of size " + this.n);
            return this.doPatch(a, new ArrayList(this.m), 1);
        }

        public List<T> backwardPatch(List<T> b) {
            CCSMPre.isTrue(b.size() == this.m, "Input word must be of size " + this.m);
            return this.doPatch(b, new ArrayList(this.n), -1);
        }

        private List<T> doPatch(List<T> a, List<T> b, int positionFactor) {
            int posA = 0;
            int posB = 0;
            for (int j = 0; j < this.position.length; ++j) {
                int k = this.position[j] * positionFactor;
                if (k > 0) {
                    --k;
                    while (posB < k) {
                        b.add(a.get(posA));
                        ++posA;
                        ++posB;
                    }
                    b.add(this.t[j]);
                    ++posB;
                    continue;
                }
                k = -k - 1;
                while (posA < k) {
                    b.add(a.get(posA));
                    ++posA;
                    ++posB;
                }
                ++posA;
            }
            while (posA < a.size()) {
                b.add(a.get(posA));
                ++posA;
                ++posB;
            }
            return b;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.position.length; ++i) {
                sb.append(Math.abs(this.position[i]) - 1);
                if (this.position[i] > 0) {
                    sb.append("+ ");
                } else {
                    sb.append("- ");
                }
                sb.append(this.t[i] + StringUtils.CR);
            }
            return sb.toString();
        }
    }
}

