/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.reuse;

import de.uni_bremen.st.reuse.BauhausStreamConstants;
import de.uni_bremen.st.reuse.IBauhausStreamWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BauhausStreamWriter
extends BauhausStreamConstants
implements IBauhausStreamWriter {
    private OutputStream stream = null;
    private File file = null;

    @Override
    public void create(String filename) throws FileNotFoundException {
        this.file = new File(filename);
        this.stream = new FileOutputStream(this.file);
    }

    @Override
    public void setStream(OutputStream stream) {
        this.stream = stream;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.stream = null;
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.writeU8(!value ? (short)0 : 1);
    }

    private void writeU8(short value) throws IOException {
        this.stream.write(value);
    }

    @Override
    public void writeCharacter(char value) throws IOException {
        this.writeU8((short)value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        if (value == Double.MAX_VALUE) {
            this.writeShortString("+MAX");
        } else if (value == Double.MIN_VALUE) {
            this.writeShortString("-MAX");
        } else {
            this.writeShortString(Double.toString(value));
        }
    }

    private void writeShortString(String string) throws IOException {
        byte[] arr = string.getBytes("UTF-8");
        this.writeU8((short)arr.length);
        this.stream.write(arr);
    }

    private void writeNaturalString(String string) throws IOException {
        byte[] arr = string.getBytes("UTF-8");
        this.writeNatural((short)arr.length);
        this.stream.write(arr);
    }

    @Override
    public <T extends Enum<T>> void writeEnum(Enum<T> enumerator) throws IOException {
        Enum[] values = (Enum[])enumerator.getClass().getEnumConstants();
        int maxOrdinal = 0;
        for (Enum e : values) {
            maxOrdinal = Math.max(maxOrdinal, e.ordinal());
        }
        if (maxOrdinal >= 0 && maxOrdinal <= 255) {
            this.writeU8((short)enumerator.ordinal());
        } else if (maxOrdinal >= 256 && maxOrdinal <= 65535) {
            this.writeU16(enumerator.ordinal());
        } else {
            this.writeN32(enumerator.ordinal());
        }
    }

    private void writeN32(long value) throws IOException {
        assert (value >= 0L && value <= 0x100000000L);
        if (value >= 0L && value <= 127L) {
            this.writeU8((short)(value + 128L));
        } else if (value >= 128L && value <= 16383L) {
            this.writeU8((short)(value / 256L + 64L));
            this.writeU8((short)(value % 256L));
        } else if (value >= 16384L && value <= 0x1FFFFFL) {
            this.writeU8((short)(value / 65536L + 32L));
            this.writeU8((short)(value / 256L % 256L));
            this.writeU8((short)(value % 256L));
        } else if (value >= 0x200000L && value <= 0xFFFFFFFL) {
            this.writeU8((short)(value / 0x1000000L + 16L));
            this.writeU8((short)(value / 65536L % 256L));
            this.writeU8((short)(value / 256L % 256L));
            this.writeU8((short)(value % 256L));
        } else if (value >= 0x10000000L && value <= Integer.MAX_VALUE) {
            this.writeU8((short)8);
            this.writeU8((short)(value / 0x1000000L));
            this.writeU8((short)(value / 65536L % 256L));
            this.writeU8((short)(value / 256L % 256L));
            this.writeU8((short)(value % 256L));
        } else {
            throw new RuntimeException("Can not encode " + value);
        }
    }

    private void writeU16(int value) throws IOException {
        assert (value >= 0 && value <= 65536);
        this.writeU8((short)(value / 256));
        this.writeU8((short)(value % 256));
    }

    @Override
    public void writeFloat(float value) throws IOException {
        if (value == Float.MAX_VALUE) {
            this.writeShortString("+MAX");
        } else if (value == Float.MIN_VALUE) {
            this.writeShortString("-MAX");
        } else {
            this.writeShortString(Float.toString(value));
        }
    }

    @Override
    public void writeInteger(int value) throws IOException {
        this.writeS32(value);
    }

    private void writeS32(int value) throws IOException {
        if (value >= 0 && value <= 63) {
            this.writeU8((short)(value + 128));
        } else if (value >= 64 && value <= 8191) {
            this.writeU8((short)(value / 256 + 64));
            this.writeU8((short)(value % 256));
        } else if (value >= 8192 && value <= 1048575) {
            this.writeU8((short)(value / 65536 + 32));
            this.writeU8((short)(value / 256 % 256));
            this.writeU8((short)(value % 256));
        } else if (value >= 0x100000 && value <= 0x7FFFFFF) {
            this.writeU8((short)(value / 0x1000000 + 16));
            this.writeU8((short)(value / 65536 % 256));
            this.writeU8((short)(value / 256 % 256));
            this.writeU8((short)(value % 256));
        } else if (value >= 0x8000000 && (long)value <= Integer.MAX_VALUE) {
            this.writeU8((short)8);
            this.writeU8((short)(value / 0x1000000));
            this.writeU8((short)(value / 65536 % 256));
            this.writeU8((short)(value / 256 % 256));
            this.writeU8((short)(value % 256));
        } else if (value >= -64 && value <= -1) {
            this.writeU8((short)(value + 256));
        } else if (value >= -8192 && value <= -65) {
            int tmp = value + 32768;
            this.writeU8((short)(tmp / 256));
            this.writeU8((short)(tmp % 256));
        } else if (value >= -1048576 && value <= -8193) {
            int tmp = value + 0x400000;
            this.writeU8((short)(tmp / 65536));
            this.writeU8((short)(tmp / 256 % 256));
            this.writeU8((short)(tmp % 256));
        } else if (value >= -134217728 && value <= -1048577) {
            int tmp = value + 0x20000000;
            this.writeU8((short)(tmp / 0x1000000));
            this.writeU8((short)(tmp / 65536 % 256));
            this.writeU8((short)(tmp / 256 % 256));
            this.writeU8((short)(tmp % 256));
        } else if ((long)value >= Integer.MIN_VALUE && value <= -134217729) {
            int I3 = (value + 1) / 0x1000000 - 1;
            int tmp = value - I3 * 0x1000000;
            this.writeU8((short)15);
            this.writeU8((short)(I3 + 256));
            this.writeU8((short)(tmp / 65536 % 256));
            this.writeU8((short)(tmp / 256 % 256));
            this.writeU8((short)(tmp % 256));
        } else {
            throw new RuntimeException("Can not write S32 " + value);
        }
    }

    @Override
    public void writeInteger8(byte value) throws IOException {
        this.writeS8(value);
    }

    private void writeS8(byte value) throws IOException {
        if (value < 0) {
            this.writeU8((short)(value + 256));
        } else {
            this.writeU8(value);
        }
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.writeS64(value);
    }

    private void writeS64(long value) throws IOException {
        if (value < Integer.MIN_VALUE || value >= 0x80000000L) {
            long i7 = value < 0L ? (value + 1L) / 0x100000000000000L - 1L : value / 0x100000000000000L;
            long rest = value - i7 * 0x100000000000000L;
            this.writeU8((short)0);
            this.writeU8((short)i7);
            this.writeU8((short)(rest / 0x1000000000000L));
            this.writeU8((short)(rest / 0x10000000000L % 256L));
            this.writeU8((short)(rest / 0x100000000L % 256L));
            this.writeU8((short)(rest / 0x1000000L % 256L));
            this.writeU8((short)(rest / 65536L % 256L));
            this.writeU8((short)(rest / 256L % 256L));
            this.writeU8((short)(rest % 256L));
        } else {
            this.writeS32((int)value);
        }
    }

    @Override
    public void writeNatural(int value) throws IOException {
        assert (value >= 0 && value <= Integer.MAX_VALUE);
        this.writeN32(value);
    }

    @Override
    public void writeString(String str) throws IOException {
        this.writeNaturalString(str);
    }

    @Override
    public void writeStringWithoutLength(String str) throws IOException {
        byte[] chars = str.getBytes();
        this.stream.write(chars);
    }

    @Override
    public void writeUnsigned64(long value) throws IOException {
        int index;
        long y;
        int base;
        int length;
        int high;
        if (value >= 0x100000000000000L) {
            high = 0;
            length = 9;
            base = 64;
            y = value;
        } else {
            int flagBit = 1;
            base = 56;
            for (length = 8; length > 1 && (double)value < Math.pow(2.0, 7 * (length - 1)); --length) {
                base -= 8;
                flagBit *= 2;
            }
            long modulus = (long)Math.pow(2.0, base);
            high = flagBit | (int)(value / modulus);
            y = value % modulus;
        }
        int[] data = new int[length];
        data[0] = high;
        for (index = 1; index < length; ++index) {
            long modulus = (long)Math.pow(2.0, base -= 8);
            data[index] = (int)(y / modulus);
            y %= modulus;
        }
        for (index = 0; index < length; ++index) {
            this.writeU8((short)data[index]);
        }
    }
}

