/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util.offsethandling;

import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.ClonePair;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.util.Pair;
import de.uni_bremen.st.rcf.util.offsethandling.OffsetCounter;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OffsetResolver {
    private static OffsetResolver instance = new OffsetResolver();

    public static OffsetResolver getInstance() {
        return instance;
    }

    private OffsetResolver() {
    }

    private boolean resolve(Map<Integer, OffsetCounter> cache, SourcePosition sourcePosition) {
        boolean couldResolveEverything = true;
        if (sourcePosition.isOffsetSet() && !sourcePosition.isLineSet() || sourcePosition.isOffsetSet() && !sourcePosition.isColumnSet()) {
            int fileId = sourcePosition.getFile().getId();
            OffsetCounter offsetCounter = cache.get(fileId);
            if (null == offsetCounter) {
                try {
                    offsetCounter = new OffsetCounter(new FileReader(sourcePosition.getFile().getAbsolutePath()));
                    cache.put(fileId, offsetCounter);
                }
                catch (IOException e) {
                    couldResolveEverything = false;
                }
            }
            if (null != offsetCounter) {
                Pair<Integer, Integer> lineColumn = offsetCounter.countLineAndColumn(sourcePosition.getOffset());
                if (!sourcePosition.isLineSet()) {
                    sourcePosition.setLine((Integer)lineColumn.first);
                }
                if (!sourcePosition.isColumnSet()) {
                    sourcePosition.setColumn((Integer)lineColumn.second);
                }
            }
        }
        return couldResolveEverything;
    }

    public boolean resolve(Version version) {
        boolean couldResolveLineNumbers = true;
        HashMap<Integer, OffsetCounter> cache = new HashMap<Integer, OffsetCounter>();
        for (CloneClass cc : version.getCloneClasses()) {
            for (Fragment f : cc.getFragments()) {
                couldResolveLineNumbers &= this.resolve(cache, f.getStart()) || f.getStart().isLineSet();
                couldResolveLineNumbers &= this.resolve(cache, f.getEnd()) || f.getEnd().isLineSet();
            }
        }
        for (ClonePair cp : version.getClonePairs()) {
            couldResolveLineNumbers &= this.resolve(cache, cp.getLeft().getStart()) || cp.getLeft().getStart().isLineSet();
            couldResolveLineNumbers &= this.resolve(cache, cp.getLeft().getEnd()) || cp.getLeft().getEnd().isLineSet();
            couldResolveLineNumbers &= this.resolve(cache, cp.getRight().getStart()) || cp.getRight().getStart().isLineSet();
            couldResolveLineNumbers &= this.resolve(cache, cp.getRight().getEnd()) || cp.getRight().getEnd().isLineSet();
        }
        return couldResolveLineNumbers;
    }

    public boolean isResolved(Fragment fragment) {
        boolean isResolved = true;
        isResolved &= fragment.getStart().isLineSet();
        isResolved &= fragment.getStart().isColumnSet();
        isResolved &= fragment.getEnd().isLineSet();
        return isResolved &= fragment.getEnd().isColumnSet();
    }
}

