/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import java.util.HashMap;

public class XMLUtils {
    private int indent = 0;
    private final StringBuilder sb = new StringBuilder();

    protected String getXMLString() {
        return this.sb.toString();
    }

    protected StringBuilder getStringBuilder() {
        return this.sb;
    }

    protected String makePrologue() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    }

    protected void makeSimpleXMLTag(String name, HashMap<String, String> attributes) {
        this.getIndent();
        this.sb.append('<');
        this.sb.append(name);
        for (String attName : attributes.keySet()) {
            this.sb.append(' ');
            this.sb.append(attName);
            this.sb.append('=');
            this.sb.append('\"');
            this.sb.append(attributes.get(attName));
            this.sb.append('\"');
        }
        this.sb.append(" />\n");
    }

    protected void makeSimpleXMLTag(String name) {
        this.makeSimpleXMLTag(name, new HashMap<String, String>());
    }

    protected String escape(String s) {
        String ret = s.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        return ret;
    }

    protected void makeOpeningXMLTag(String name, HashMap<String, String> attributes, boolean inline) {
        this.getIndent();
        this.sb.append('<');
        this.sb.append(name);
        for (String attName : attributes.keySet()) {
            this.sb.append(' ');
            this.sb.append(attName);
            this.sb.append('=');
            this.sb.append('\"');
            this.sb.append(attributes.get(attName));
            this.sb.append('\"');
        }
        this.sb.append(">");
        if (inline) {
            this.sb.append("\n");
            ++this.indent;
        }
    }

    protected void makeOpeningXMLTag(String name, boolean inline) {
        this.makeOpeningXMLTag(name, new HashMap<String, String>(), inline);
    }

    protected void makeClosingXMLTag(String name, boolean inline) {
        if (inline) {
            --this.indent;
            this.getIndent();
        }
        this.sb.append("</");
        this.sb.append(name);
        this.sb.append(">\n");
        if (inline) {
            this.sb.append("\n");
        }
    }

    protected void makeXMLComment(String comment) {
        this.getIndent();
        this.sb.append("<!-- ");
        this.sb.append(comment);
        this.sb.append(" -->\n");
    }

    protected void getIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.sb.append('\t');
        }
    }
}

