/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.util.XMLSchemaWriter;
import de.uni_bremen.st.rcf.util.XMLUtils;
import java.io.PrintStream;

public class XMLOutput
extends XMLUtils {
    private static PrintStream out = System.out;
    private final RCF rcf;

    public XMLOutput(RCF rcf) {
        this.rcf = rcf;
    }

    public void print() {
        this.makeOpeningXMLTag("rcf", true);
        this.makePrologue();
        this.makeSchema();
        this.printRelations();
        this.makeClosingXMLTag("rcf", true);
        out.print(this.getXMLString());
    }

    private void makeSchema() {
        XMLSchemaWriter schemaWriter = new XMLSchemaWriter(this.rcf, false);
        this.makeOpeningXMLTag("schema", true);
        this.getStringBuilder().append(schemaWriter.getSchemaString());
        this.makeClosingXMLTag("schema", true);
    }

    private void printRelations() {
        this.makeOpeningXMLTag("data", true);
        for (Relation<Entry> rel : this.rcf.getRelations()) {
            this.printRelation(rel);
        }
        this.makeClosingXMLTag("data", true);
    }

    private void printRelation(Relation<Entry> relation) {
        String xmlRelName = this.pluralize(relation.getName());
        this.makeOpeningXMLTag(xmlRelName, true);
        for (Entry entry : relation) {
            this.printEntry(entry);
        }
        this.makeClosingXMLTag(xmlRelName, true);
    }

    private void printEntry(Entry entry) {
        this.makeOpeningXMLTag(entry.getRelation().getName(), true);
        for (Attribute attribute : entry.getRelation().getAttributes()) {
            this.printAttribute(attribute, entry);
        }
        this.makeClosingXMLTag(entry.getRelation().getName(), true);
    }

    private void printAttribute(Attribute attribute, Entry entry) {
        if (attribute.isList()) {
            if (entry.getIntList(attribute).size() > 0) {
                this.makeOpeningXMLTag(attribute.getName(), false);
                this.printListAttributeValues(attribute, entry);
                this.makeClosingXMLTag(attribute.getName(), false);
            }
        } else if (entry.isSet(attribute)) {
            this.makeOpeningXMLTag(attribute.getName(), false);
            switch (attribute.getType()) {
                case INTEGER: 
                case REFERENCE: {
                    this.getStringBuilder().append(entry.getInt(attribute));
                    break;
                }
                case STRING: {
                    this.getStringBuilder().append(entry.getString(attribute));
                    break;
                }
                case FLOAT: {
                    this.getStringBuilder().append(entry.getFloat(attribute));
                    break;
                }
                case BOOLEAN: {
                    this.getStringBuilder().append(entry.getBool(attribute));
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            this.makeClosingXMLTag(attribute.getName(), false);
        }
    }

    private void printListAttributeValues(Attribute attribute, Entry entry) {
        switch (attribute.getType()) {
            case INTEGER: {
                for (Integer i : entry.getIntList(attribute)) {
                    this.printListAttributeValue(i.toString());
                }
                break;
            }
            case REFERENCE: {
                for (Entry e : entry.getEntryList(attribute)) {
                    this.printListAttributeValue(Integer.toString(e.getId()));
                }
                break;
            }
            case STRING: {
                for (String s : entry.getStringList(attribute)) {
                    this.printListAttributeValue(s);
                }
                break;
            }
            case FLOAT: {
                for (Float f : entry.getFloatList(attribute)) {
                    this.printListAttributeValue(f.toString());
                }
                break;
            }
            case BOOLEAN: {
                for (Boolean b : entry.getBoolList(attribute)) {
                    this.printListAttributeValue(b.toString());
                }
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void printListAttributeValue(String s) {
        this.getStringBuilder().append("<v>" + this.escape(s) + "</v>");
    }

    private String pluralize(String s) {
        if (s.endsWith("s")) {
            return s + "es";
        }
        if (s.endsWith("y")) {
            return s.substring(0, s.length() - 1) + "ies";
        }
        return s + "s";
    }
}

