/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.imports.Import;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.persistence.AbstractPersistenceManager;
import de.uni_bremen.st.rcf.persistence.PersistenceManagerFactory;
import de.uni_bremen.st.rcf.persistence.bauhaus.BauhausPersistenceManager;
import de.uni_bremen.st.rcf.util.CCFOutput;
import de.uni_bremen.st.rcf.util.CPFOutput;
import de.uni_bremen.st.rcf.util.FileRatios;
import de.uni_bremen.st.rcf.util.MetadataOutput;
import de.uni_bremen.st.rcf.util.ModifyBasepath;
import de.uni_bremen.st.rcf.util.VersionExtractor;
import de.uni_bremen.st.rcf.util.XMLOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class RCFTool {
    private static OptionParser op = null;
    private static OptionSpec<String> opMode;
    private static OptionSpec<String> opBasepath;
    private static OptionSpec<Integer> opVersion;
    private static OptionSpec<Void> opColumns;
    private static OptionSpec<Integer> opExcludeTypes;

    private RCFTool() {
    }

    private static synchronized OptionParser getOptionParser() {
        if (op == null) {
            op = new OptionParser();
            opMode = op.acceptsAll(Arrays.asList("mode", "m")).withRequiredArg().ofType(String.class);
            opBasepath = op.acceptsAll(Arrays.asList("basepath", "b")).withRequiredArg().ofType(String.class);
            opVersion = op.acceptsAll(Arrays.asList("version", "v")).withRequiredArg().ofType(Integer.class);
            opColumns = op.accepts("print-cols");
            opExcludeTypes = op.acceptsAll(Arrays.asList("exclude-types", "e")).withRequiredArg().withValuesSeparatedBy(',').ofType(Integer.class);
        }
        return op;
    }

    private static void printUsage() {
        try {
            System.out.println("\nUsage: rcftool OPTIONS FILES...\n");
            RCFTool.getOptionParser().printHelpOn(System.out);
            System.out.println();
            System.out.println("Modes: ccf2rcf           Transform ccf to rcf. (requires basepath)\n       cpf2rcf           Transform cpf to rcf. (requires basepath)\n       cpd2rcf           Transform cpd (PMD) to rcf. (requires basepath)\n       simian2rcf        Transform Simian output to rcf. (requires basepath)\n       simscan2rcf       Transform SimScan output to rcf.\n       rcf2cpf           Transform rcf to cpf.\n       rcf2ccf           Transform rcf to ccf. (Use --print-cols to write LC-Format)\n       rcf2xml           Transform rcf to XML.\n       basepath          Lets you modify the basepath of each version in a RCF\n       ccfxprepdir       Lets you modify the basepath of the ccfxprepdir (by default it is .ccfxprepdir in the root directory of scanned source-files)\n       file_ratios       Calculates the amount of clones lines between all\n                         pairs of files. Result is reported as csv data and\n                         calculates the ratio of code cloned in the other file.\n       metadata          Print the process data for the creation of rcf contents.\n       extract_version   Extracts the version with the given id to a new RCF.\n       extract_all       Extracts all version with in the given RCF.\n       sizes             Print the sizes of all relations in a rcf file.\n\n");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void error(String msg) throws RuntimeException {
        RCFTool.error(msg, null);
    }

    private static void error(String msg, Throwable cause) throws RuntimeException {
        throw new RuntimeException(msg, cause);
    }

    public static void main(String[] args) {
        OptionParser parser = RCFTool.getOptionParser();
        try {
            OptionSet opSet = parser.parse(args);
            if (!opSet.has(opMode)) {
                RCFTool.error("Parameter mode must be given");
            }
            List<String> files = opSet.nonOptionArguments();
            String mode = opSet.valueOf(opMode);
            if (mode.equalsIgnoreCase("ccf2rcf") || mode.equalsIgnoreCase("cpf2rcf") || mode.equalsIgnoreCase("cpd2rcf") || mode.equalsIgnoreCase("simian2rcf") || mode.equalsIgnoreCase("ccfx2rcf")) {
                RCFTool.requireFiles(mode, files, 2);
                if (!opSet.has(opBasepath)) {
                    RCFTool.error(mode + " requires a basepath");
                }
                Import.CloneFormat format = null;
                if (mode.equalsIgnoreCase("ccf2rcf")) {
                    format = Import.CloneFormat.CCF;
                } else if (mode.equalsIgnoreCase("cpf2rcf")) {
                    format = Import.CloneFormat.CPF;
                } else if (mode.equalsIgnoreCase("cpd2rcf")) {
                    format = Import.CloneFormat.CPD;
                } else if (mode.equalsIgnoreCase("simian2rcf")) {
                    format = Import.CloneFormat.SIMIAN;
                } else if (mode.equalsIgnoreCase("ccfx2rcf")) {
                    format = Import.CloneFormat.CCFX;
                }
                Import.importData(format, files.get(0), files.get(1), opSet.valueOf(opBasepath));
            } else if (mode.equalsIgnoreCase("simscan2rcf")) {
                Import.importData(Import.CloneFormat.SIMSCAN, files.get(0), files.get(1), "");
            } else if (mode.equalsIgnoreCase("rcf2cpf") || mode.equalsIgnoreCase("rcf2ccf") || mode.equalsIgnoreCase("rcf2xml")) {
                RCFTool.requireFiles(mode, files, 1);
                RCFTool.outputRcf(files.get(0), mode.toLowerCase(), opSet);
            } else if (mode.equalsIgnoreCase("basepath")) {
                RCFTool.requireFiles(mode, files, 1);
                RCFTool.changeBasepath(files.get(0));
            } else if (mode.equalsIgnoreCase("file_ratios")) {
                RCFTool.requireFiles(mode, files, 1);
                RCFTool.printFileRatios(files.get(0));
            } else if (mode.equalsIgnoreCase("metadata")) {
                RCFTool.requireFiles(mode, files, 1);
                RCFTool.printMetadata(files.get(0));
            } else if (mode.equalsIgnoreCase("extract_version")) {
                RCFTool.requireFiles(mode, files, 2);
                if (!opSet.has(opVersion)) {
                    RCFTool.error(mode + " requires a version id");
                }
                RCFTool.extractVersion(files.get(0), files.get(1), (int)opSet.valueOf(opVersion));
            } else if (mode.equalsIgnoreCase("extract_all")) {
                RCFTool.requireFiles(mode, files, 1);
                RCFTool.extractAllVersions(files.get(0));
            } else if (mode.equalsIgnoreCase("sizes")) {
                RCFTool.requireFiles(mode, files, 1);
                RCFTool.printSizes(files.get(0));
            } else {
                RCFTool.error("Unknown mode " + mode + ".");
            }
        }
        catch (RuntimeException e) {
            if (e.getMessage() == null) {
                e.printStackTrace();
            } else {
                System.out.println(e.getMessage());
            }
            RCFTool.printUsage();
        }
    }

    private static void requireFiles(String mode, List<String> files, int num) {
        if (files.size() != num) {
            RCFTool.error(mode + " requires " + num + " file" + (num > 1 ? "s" : ""));
        }
    }

    private static RCF createRCF(File rcfFile) {
        BauhausPersistenceManager bpm = new BauhausPersistenceManager();
        return bpm.create(rcfFile);
    }

    private static RCF loadRCF(File rcfFile) {
        AbstractPersistenceManager apm;
        try {
            apm = PersistenceManagerFactory.getPersistenceManager(rcfFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File " + rcfFile.getPath() + " not found!");
        }
        return apm.load(rcfFile);
    }

    private static void outputRcf(String filename, String mode, OptionSet opSet) {
        ArrayList<Object> excludedTypes = new ArrayList(0);
        if (opSet.has(opExcludeTypes)) {
            excludedTypes = new ArrayList<Integer>(opSet.valuesOf(opExcludeTypes));
            if (excludedTypes.size() > 3) {
                RCFTool.error("Only three clone types can be defined.");
            }
            Iterator<Object> i$ = excludedTypes.iterator();
            while (i$.hasNext()) {
                int t = (Integer)i$.next();
                if (t >= 1 && t <= 3) continue;
                RCFTool.error("The clone type must be between 1 and 3.");
            }
        }
        boolean printColumns = opSet.has(opColumns);
        File rcfFile = new File(filename);
        RCF rcf = RCFTool.loadRCF(rcfFile);
        if (mode.equals("rcf2cpf")) {
            CPFOutput.printCPF(rcf, excludedTypes);
        } else if (mode.equals("rcf2ccf")) {
            CCFOutput.printCCF(rcf, excludedTypes, printColumns);
        } else if (mode.equals("rcf2xml")) {
            XMLOutput out = new XMLOutput(rcf);
            out.print();
        }
        rcf.close();
    }

    private static void changeBasepath(String rcfFilename) {
        try {
            File rcfFile = new File(rcfFilename);
            RCF rcf = RCFTool.loadRCF(rcfFile);
            ModifyBasepath.modifyInteractive(rcf);
            rcf.close();
        }
        catch (IOException ioe) {
            RCFTool.error(ioe.getMessage(), ioe);
        }
    }

    private static void printMetadata(String filename) {
        File rcfFile = new File(filename);
        RCF rcf = RCFTool.loadRCF(rcfFile);
        MetadataOutput.printMetaData(rcf);
        rcf.close();
    }

    private static void extractAllVersions(String from) {
        File fromFile = new File(from);
        System.out.println("   Reading RCF " + from + "...");
        RCF fromRCF = RCFTool.loadRCF(fromFile);
        for (Version v : fromRCF.getVersions()) {
            String toPath;
            int versionId = v.getId();
            String fromPath = fromRCF.getFile().getAbsolutePath();
            if (fromPath.equals(toPath = fromPath.replaceAll("\\.rcf$", "-v" + Integer.toString(versionId) + ".rcf"))) {
                throw new IllegalArgumentException("RCF files must end with '.rcf'!");
            }
            File toRCFFile = new File(toPath);
            RCF toRCF = RCFTool.createRCF(toRCFFile);
            System.out.println("   Extracting version: " + Integer.toString(versionId));
            RCFTool.extractVersion(fromRCF, toRCF, versionId);
        }
    }

    private static void extractVersion(String from, String to, int versionId) {
        File fromFile = new File(from);
        File toFile = new File(to);
        RCF fromRCF = RCFTool.loadRCF(fromFile);
        RCF toRCF = null;
        if (toFile.exists()) {
            throw new IllegalArgumentException("Target RCF file exists!");
        }
        toRCF = RCFTool.createRCF(toFile);
        RCFTool.extractVersion(fromRCF, toRCF, versionId);
    }

    private static void extractVersion(RCF fromRCF, RCF toRCF, int versionId) {
        VersionExtractor ve = new VersionExtractor();
        ve.extractVersion(fromRCF, toRCF, versionId);
        toRCF.save();
    }

    private static void printSizes(String filename) {
        File rcfFile = new File(filename);
        RCF rcf = RCFTool.loadRCF(rcfFile);
        System.out.format("Sizes for RCF file %s:\n", filename);
        System.out.format("----------------------------------------------------\n", new Object[0]);
        System.out.format("\tNumber of versions: %d\n", rcf.getRelation("Version").size());
        System.out.format("\tNumber of directories: %d\n", rcf.getRelation("Directory").size());
        System.out.format("\tNumber of files: %d\n", rcf.getRelation("File").size());
        System.out.format("\tNumber of fragments: %d\n", rcf.getRelation("Fragment").size());
        System.out.format("\tNumber of clone pairs: %d\n", rcf.getRelation("ClonePair").size());
        System.out.format("\tNumber of clone classes: %d\n", rcf.getRelation("CloneClass").size());
        rcf.close();
    }

    private static void printFileRatios(String filename) {
        File rcfFile = new File(filename);
        RCF rcf = RCFTool.loadRCF(rcfFile);
        System.out.println(FileRatios.printFileRatios((Version)rcf.getVersions().getFirstEntry()));
        rcf.close();
    }
}

