/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.schema;

import de.uni_bremen.st.rcf.schema.AttributePOJO;
import de.uni_bremen.st.rcf.schema.AttributeType;
import de.uni_bremen.st.rcf.schema.RelationPOJO;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler {
    private RelationPOJO currentRelation = null;
    private AttributePOJO currentAttribute = null;
    private boolean expectEnumValue = false;
    private boolean finished = false;
    private final Map<String, RelationPOJO> relations = new HashMap<String, RelationPOJO>();

    protected SAXHandler() {
    }

    protected Collection<RelationPOJO> getRelations() {
        if (this.finished) {
            return this.relations.values();
        }
        throw new IllegalStateException("Tried to collect results before parsing finished!");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.expectEnumValue) {
            String s = new String(Arrays.copyOfRange(ch, start, start + length));
            this.currentAttribute.addEnumValue(s);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.finished = true;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (name.equals("attr")) {
            this.currentAttribute = null;
        } else if (name.equals("enumValue")) {
            this.expectEnumValue = false;
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (!name.equals("rcf")) {
            if (name.equals("relation")) {
                String rname = attributes.getValue("name");
                if (this.relations.containsKey(rname)) {
                    this.currentRelation = this.relations.get(rname);
                } else {
                    this.currentRelation = new RelationPOJO(rname);
                    this.relations.put(rname, this.currentRelation);
                }
            } else if (name.equals("attr")) {
                AttributePOJO att;
                this.currentAttribute = att = new AttributePOJO();
                boolean nameSeen = false;
                boolean typeSeen = false;
                block11: for (int i = 0; i < attributes.getLength(); ++i) {
                    String attName = attributes.getQName(i);
                    String attValue = attributes.getValue(i);
                    AttributeFields field = AttributeFields.toAttributeField(attName);
                    switch (field) {
                        case name: {
                            nameSeen = true;
                            att.setName(attValue);
                            continue block11;
                        }
                        case type: {
                            typeSeen = true;
                            try {
                                AttributeType t = AttributeType.valueOf(attValue.toUpperCase());
                                att.setType(t);
                                continue block11;
                            }
                            catch (IllegalArgumentException iae) {
                                throw new SAXException(String.format("Invalid type %s of attribute %s.%s", attValue, this.currentRelation.getName(), att.getName()));
                            }
                        }
                        case desc: {
                            continue block11;
                        }
                        case isEnum: {
                            if (attValue.equals("yes")) {
                                att.setEnum(true);
                                continue block11;
                            }
                            att.setEnum(false);
                            continue block11;
                        }
                        case isList: {
                            if (attValue.equals("yes")) {
                                att.setList(true);
                                continue block11;
                            }
                            att.setList(false);
                            continue block11;
                        }
                        case refRelation: {
                            if (!this.relations.containsKey(attValue)) {
                                RelationPOJO rel = new RelationPOJO(attValue);
                                this.relations.put(attValue, rel);
                            }
                            att.setReferencedRelation(this.relations.get(attValue));
                            continue block11;
                        }
                        case cached: {
                            if (attValue.equals("yes")) {
                                att.setCached(true);
                                continue block11;
                            }
                            att.setCached(false);
                            continue block11;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (!nameSeen || !typeSeen) {
                    throw new AssertionError((Object)"Each Attribute must have at least name and type!");
                }
                if (!att.getName().equals("id")) {
                    this.currentRelation.addAttribute(att);
                }
            } else if (name.equals("enumValue")) {
                if (this.currentAttribute == null) {
                    throw new SAXException("Found <enumValue> tag outside an <attr> tag.");
                }
                this.expectEnumValue = true;
            } else {
                throw new SAXException("Found unexpeced element " + name);
            }
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        super.warning(e);
        System.err.println(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        super.error(e);
        System.err.println(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        super.fatalError(e);
        System.err.println(e);
    }

    static enum AttributeFields {
        name,
        type,
        desc,
        isList,
        isEnum,
        refRelation,
        cached;


        public static AttributeFields toAttributeField(String name) {
            try {
                return AttributeFields.valueOf(name);
            }
            catch (IllegalArgumentException iae) {
                throw new AssertionError((Object)("Attribute " + name + " is not known."));
            }
        }
    }
}

