/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bauhaus;

import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.RCFBinding;
import de.uni_bremen.st.rcf.util.XMLSchemaWriter;
import de.uni_bremen.st.reuse.BauhausStreamWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Writer {
    private BauhausStreamWriter out;
    private final RCFBinding rcf;

    protected Writer(RCFBinding rcf) {
        this.rcf = rcf;
    }

    protected void write(File f) throws FileNotFoundException {
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.out = new BauhausStreamWriter();
        this.out.setStream(new FileOutputStream(f));
        try {
            this.writeVersionInfo();
            String schema = this.createSchemaString();
            this.out.writeString(schema);
            for (AbstractRelationBinding rel : this.rcf.getRelations()) {
                for (AbstractAttributeBinding att : rel.getAttributes()) {
                    this.writeAttributeData((AttributeBinding)att);
                }
            }
            this.out.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void writeVersionInfo() throws IOException {
        this.out.writeString("RCF 2.1");
    }

    private String createSchemaString() {
        XMLSchemaWriter w = new XMLSchemaWriter(new RCF(this.rcf), true);
        return w.getSchemaString();
    }

    private void writeAttributeData(AttributeBinding attribute) throws IOException {
        this.out.writeString(attribute.getRelation().getName() + '.' + attribute.getName());
        int numValues = 0;
        switch (attribute.getType()) {
            case INTEGER: 
            case REFERENCE: {
                numValues = attribute.intData.size();
                break;
            }
            case FLOAT: {
                numValues = attribute.floatData.size();
                break;
            }
            case STRING: {
                numValues = attribute.stringData.size();
                break;
            }
            case BOOLEAN: {
                numValues = attribute.boolData.size();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.out.writeInteger(numValues);
        switch (attribute.getType()) {
            case INTEGER: 
            case REFERENCE: {
                for (int i = 0; i < attribute.intData.size(); ++i) {
                    this.out.writeInteger(attribute.intData.get(i));
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < attribute.floatData.size(); ++i) {
                    this.out.writeFloat(attribute.floatData.get(i));
                }
                break;
            }
            case STRING: {
                for (String s : attribute.stringData) {
                    this.out.writeString(s);
                }
                break;
            }
            case BOOLEAN: {
                for (int i = 0; i < attribute.boolData.size(); ++i) {
                    this.out.writeInteger8(attribute.boolData.get(i));
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (attribute.isList()) {
            int i;
            this.out.writeInteger(attribute.listStarts.size());
            for (i = 0; i < attribute.listStarts.size(); ++i) {
                this.out.writeInteger(attribute.listStarts.get(i));
            }
            this.out.writeInteger(attribute.listEnds.size());
            for (i = 0; i < attribute.listEnds.size(); ++i) {
                this.out.writeInteger(attribute.listEnds.get(i));
            }
            this.out.writeInteger(attribute.nextIndex.size());
            for (i = 0; i < attribute.nextIndex.size(); ++i) {
                this.out.writeInteger(attribute.nextIndex.get(i));
            }
        }
    }
}

