/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bauhaus;

import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.FormatInfo;
import de.uni_bremen.st.rcf.persistence.bauhaus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.EntryBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.IReader;
import de.uni_bremen.st.rcf.persistence.bauhaus.RCFBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.RelationBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.RelationIteratorBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import de.uni_bremen.st.reuse.BauhausStreamReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Reader20
implements IReader {
    protected static final char UNSET_BOOLEAN_VALUE = '?';
    protected static final char TRUE_BOOLEAN_VALUE = '1';
    protected static final char FALSE_BOOLEAN_VALUE = '0';
    private State state = State.VIRGIN;
    private final BauhausStreamReader reader = new BauhausStreamReader();
    private final RCFBinding rcfBinding;
    private RelationBinding curRel = null;
    private final Map<Integer, AttributeBinding> attributeMap = new HashMap<Integer, AttributeBinding>();
    private boolean inList = false;
    private String[] schemaLines;
    private final File file;

    Reader20(File file) {
        this.file = file;
        this.rcfBinding = new RCFBinding(file);
    }

    @Override
    public void read() throws IOException {
        this.reader.open(this.file.getAbsolutePath());
        this.reader.readString();
        String schema = this.reader.readString();
        this.parseSchema(schema);
        while (!this.reader.isEOF()) {
            this.readAttributeData();
        }
        this.transformFragmentPositions();
        this.transformCloneTypes();
        this.refreshRelations();
        this.state = State.LOADED;
    }

    @Override
    public boolean isCompatible(FormatInfo fi) {
        return false;
    }

    @Override
    public RCFBinding getRCFBinding() {
        if (this.state != State.LOADED) {
            throw new IllegalStateException("Must load an RCF before calling getBinding()!");
        }
        return this.rcfBinding;
    }

    private void refreshRelations() {
        for (AbstractRelationBinding arb : this.rcfBinding.getRelations()) {
            RelationBinding rb = (RelationBinding)arb;
            rb.refresh();
        }
    }

    private void parseSchema(String schema) {
        this.schemaLines = schema.split("\n");
        for (int i = 0; i < this.schemaLines.length; ++i) {
            String line = this.schemaLines[i];
            String[] tokens = line.trim().split(" ");
            String token = tokens[0];
            if (token.equals(SchemaTokens.RELATION_TAG.getValue())) {
                this.parseRelationTag(tokens);
                continue;
            }
            if (token.equals(SchemaTokens.ATTRIBUTE_TAG.getValue())) {
                if (this.inList) continue;
                this.parseAttributeTag(tokens, i);
                continue;
            }
            if (!token.equals(SchemaTokens.END_TAG.getValue())) continue;
            this.inList = false;
        }
    }

    private RelationBinding getOrCreateRelation(String name) {
        RelationBinding rel = this.rcfBinding.hasRelation(name) ? (RelationBinding)this.rcfBinding.getRelation(name) : (RelationBinding)this.rcfBinding.addRelation(name);
        return rel;
    }

    private void parseRelationTag(String[] tokens) {
        String name = tokens[1];
        this.curRel = this.getOrCreateRelation(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAttributeTag(String[] tokens, int lineIndex) {
        int attId = Integer.valueOf(tokens[1]);
        String name = tokens[2];
        if (name.equals("id")) {
            AttributeBinding a = this.curRel.getIdAttribute();
            this.attributeMap.put(attId, a);
            return;
        }
        String[] parts = name.split("_");
        String newName = parts[0];
        if (parts.length == 0) {
            newName = "_";
        } else if (parts.length == 1) {
            newName = parts[0];
        } else {
            StringBuilder sb = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i].length() == 1) {
                    sb.append(parts[i].toUpperCase(Locale.getDefault()));
                    continue;
                }
                sb.append(Character.toUpperCase(parts[i].charAt(0)) + parts[i].substring(1));
            }
            newName = sb.toString();
        }
        String typeValue = tokens[3];
        AttributeType type = null;
        RelationBinding refRel = null;
        String[] enumValues = null;
        boolean isList = false;
        boolean isEnum = false;
        if (typeValue.startsWith(SchemaTokens.ATT_TYPE_REFERENCE.getValue())) {
            type = AttributeType.REFERENCE;
            refRel = this.getOrCreateRelation(typeValue.substring(3, typeValue.length() - 1));
        } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_INTEGER.getValue())) {
            type = AttributeType.INTEGER;
        } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_STRING.getValue())) {
            type = name.equals("type") ? AttributeType.INTEGER : AttributeType.STRING;
        } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_BOOLEAN.getValue())) {
            type = AttributeType.BOOLEAN;
        } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_FLOAT.getValue())) {
            type = AttributeType.FLOAT;
        } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_ID.getValue())) {
            type = AttributeType.INTEGER;
        } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_LIST.getValue())) {
            isList = true;
            this.inList = true;
            String nextLine = this.schemaLines[lineIndex + 1];
            String[] nextLineTokens = nextLine.split(" ");
            typeValue = nextLineTokens[3];
            if (typeValue.startsWith(SchemaTokens.ATT_TYPE_REFERENCE.getValue())) {
                type = AttributeType.REFERENCE;
                refRel = this.getOrCreateRelation(typeValue.substring(3, typeValue.length() - 1));
            } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_INTEGER.getValue())) {
                type = AttributeType.INTEGER;
            } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_STRING.getValue())) {
                type = AttributeType.STRING;
            } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_BOOLEAN.getValue())) {
                type = AttributeType.BOOLEAN;
            } else if (typeValue.startsWith(SchemaTokens.ATT_TYPE_FLOAT.getValue())) {
                type = AttributeType.FLOAT;
            } else {
                if (!typeValue.startsWith(SchemaTokens.ATT_TYPE_ID.getValue())) throw new AssertionError();
                type = AttributeType.INTEGER;
            }
        } else {
            if (!typeValue.startsWith("{")) throw new AssertionError((Object)"Error reading attribute spec.");
            typeValue = typeValue.substring(1, typeValue.length() - 1);
            enumValues = typeValue.split(",");
            for (int i = 0; i < enumValues.length; ++i) {
                enumValues[i] = enumValues[i].replace("'", "");
            }
            isEnum = true;
            type = AttributeType.STRING;
        }
        String desc = "";
        if (tokens.length == 5) {
            desc = tokens[4];
        } else if (tokens.length > 5) {
            for (int i = 4; i < tokens.length; ++i) {
                desc = desc + tokens[i] + " ";
            }
            desc = desc.trim();
        }
        AttributeBinding att = (AttributeBinding)this.curRel.addAttribute(newName, type, isList, isEnum, refRel, enumValues);
        this.attributeMap.put(attId, att);
    }

    private void readAttributeData() throws IOException {
        int attId = this.reader.readInteger();
        AttributeBinding att = this.attributeMap.get(attId);
        if (att == null) {
            return;
        }
        if (att.isList()) {
            int i;
            int numValues = this.reader.readInteger();
            att.listStarts.ensureCapacity(numValues);
            att.listEnds.ensureCapacity(numValues);
            for (i = 0; i < numValues; i += 2) {
                int b = this.reader.readInteger();
                int e = this.reader.readInteger();
                att.listStarts.add(b);
                att.listEnds.add(e);
            }
            this.reader.readInteger();
            numValues = this.reader.readInteger();
            switch (att.getType()) {
                case INTEGER: 
                case REFERENCE: {
                    int v;
                    att.intData.ensureCapacity(numValues);
                    for (i = 0; i < numValues; ++i) {
                        v = this.reader.readInteger();
                        att.intData.add(v);
                    }
                    break;
                }
                case BOOLEAN: {
                    int v;
                    att.intData.ensureCapacity(numValues);
                    for (i = 0; i < numValues; ++i) {
                        v = this.reader.readCharacter();
                        int intValue = 0;
                        intValue = v == 49 ? 1 : (v == 48 ? 0 : -1);
                        att.intData.add(intValue);
                    }
                    break;
                }
                case FLOAT: {
                    att.floatData.ensureCapacity(numValues);
                    for (i = 0; i < numValues; ++i) {
                        float v = this.reader.readFloat();
                        att.floatData.add(v);
                    }
                    break;
                }
                case STRING: {
                    att.stringData.ensureCapacity(numValues);
                    for (i = 0; i < numValues; ++i) {
                        String v = this.reader.readString();
                        att.stringData.add(v);
                    }
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.reader.readInteger();
            numValues = this.reader.readInteger();
            for (int j = 0; j < numValues; ++j) {
                int v = this.reader.readInteger();
                att.nextIndex.add(v);
            }
        } else {
            int numValues = this.reader.readInteger();
            switch (att.getType()) {
                case INTEGER: 
                case REFERENCE: {
                    att.intData.ensureCapacity(numValues);
                    for (int i = 0; i < numValues; ++i) {
                        int v = this.reader.readInteger();
                        att.intData.add(v);
                    }
                    break;
                }
                case BOOLEAN: {
                    att.boolData.ensureCapacity(numValues);
                    for (int i = 0; i < numValues; ++i) {
                        char v = this.reader.readCharacter();
                        byte byteValue = 0;
                        byteValue = v == '1' ? (byte)1 : (v == '0' ? (byte)0 : -1);
                        att.boolData.add(byteValue);
                    }
                    break;
                }
                case FLOAT: {
                    att.floatData.ensureCapacity(numValues);
                    for (int i = 0; i < numValues; ++i) {
                        float v = this.reader.readFloat();
                        att.floatData.add(v);
                    }
                    break;
                }
                case STRING: {
                    att.stringData.ensureCapacity(numValues);
                    for (int i = 0; i < numValues; ++i) {
                        String v = this.reader.readString();
                        att.stringData.add(v);
                    }
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private void transformFragmentPositions() {
        RelationBinding spRel = (RelationBinding)this.rcfBinding.addRelation("SourcePosition");
        spRel.addAttribute("file", AttributeType.REFERENCE, false, false, this.rcfBinding.getRelation("File"), new String[0]);
        spRel.addAttribute("line", AttributeType.INTEGER, false, false, null, new String[0]);
        spRel.addAttribute("column", AttributeType.INTEGER, false, false, null, new String[0]);
        spRel.addAttribute("offset", AttributeType.INTEGER, false, false, null, new String[0]);
        RelationBinding fragRel = (RelationBinding)this.rcfBinding.getRelation("Fragment");
        RelationIteratorBinding rib = new RelationIteratorBinding(fragRel);
        AttributeBinding attId = fragRel.getIdAttribute();
        AttributeBinding attFile = (AttributeBinding)fragRel.getAttribute("file");
        AttributeBinding attBeginLine = (AttributeBinding)fragRel.getAttribute("beginLine");
        AttributeBinding attBeginCol = (AttributeBinding)fragRel.getAttribute("beginColumn");
        AttributeBinding attEndLine = (AttributeBinding)fragRel.getAttribute("endLine");
        AttributeBinding attEndCol = (AttributeBinding)fragRel.getAttribute("endColumn");
        AttributeBinding attStart = (AttributeBinding)fragRel.addAttribute("start", AttributeType.REFERENCE, false, false, spRel, new String[0]);
        AttributeBinding attEnd = (AttributeBinding)fragRel.addAttribute("end", AttributeType.REFERENCE, false, false, spRel, new String[0]);
        for (int i = 0; i < attId.intData.size(); ++i) {
            attStart.intData.add(Integer.MIN_VALUE);
            attEnd.intData.add(Integer.MIN_VALUE);
        }
        while (rib.hasNext()) {
            EntryBinding fragment = (EntryBinding)rib.next();
            int fileId = fragment.getEntry(attFile).getId();
            int beginLine = fragment.getInt(attBeginLine);
            int beginCol = fragment.getInt(attBeginCol);
            int endLine = fragment.getInt(attEndLine);
            int endCol = fragment.getInt(attEndCol);
            int beginPosition = this.addSourcePosition(fileId, beginLine, beginCol, Integer.MIN_VALUE);
            int endPosition = this.addSourcePosition(fileId, endLine, endCol, Integer.MIN_VALUE);
            attStart.intData.set(fragment.offset, beginPosition);
            attEnd.intData.set(fragment.offset, endPosition);
        }
        attFile.intData.clear(0);
        fragRel.attributes.remove(attFile.getName());
        attBeginLine.intData.clear(0);
        fragRel.attributes.remove(attBeginLine.getName());
        attEndLine.intData.clear(0);
        fragRel.attributes.remove(attEndLine.getName());
        attBeginCol.intData.clear(0);
        fragRel.attributes.remove(attBeginCol.getName());
        attEndCol.intData.clear(0);
        fragRel.attributes.remove(attEndCol.getName());
    }

    private int addSourcePosition(int fileId, int line, int col, int offset) {
        RelationBinding relSP = (RelationBinding)this.rcfBinding.getRelation("SourcePosition");
        AttributeBinding attId = relSP.idAttribute;
        AttributeBinding attFile = (AttributeBinding)relSP.getAttribute("file");
        AttributeBinding attLine = (AttributeBinding)relSP.getAttribute("line");
        AttributeBinding attCol = (AttributeBinding)relSP.getAttribute("column");
        AttributeBinding attOffset = (AttributeBinding)relSP.getAttribute("offset");
        int id = attId.intData.isEmpty() ? 1 : attId.intData.get(attId.intData.size() - 1) + 1;
        attId.intData.add(id);
        attFile.intData.add(fileId);
        attLine.intData.add(line);
        attCol.intData.add(col);
        attOffset.intData.add(offset);
        return id;
    }

    private void transformCloneTypes() {
        this.intToString((AttributeBinding)this.rcfBinding.getRelation("ClonePair").getAttribute("type"));
        this.intToString((AttributeBinding)this.rcfBinding.getRelation("CloneClass").getAttribute("type"));
    }

    private void intToString(AttributeBinding ab) {
        ab.setType(AttributeType.INTEGER);
        for (String s : ab.stringData) {
            ab.intData.add(Integer.valueOf(s));
        }
        ab.stringData.clear();
    }

    static enum State {
        VIRGIN,
        LOADED;

    }

    static enum SchemaTokens {
        RCF_TAG("@RCF"),
        RELATION_TAG("@RELATION"),
        ATTRIBUTE_TAG("@ATTRIBUTE"),
        END_TAG("@END"),
        ATT_TYPE_ID("ID"),
        ATT_TYPE_INTEGER("INTEGER"),
        ATT_TYPE_STRING("STRING"),
        ATT_TYPE_FLOAT("FLOAT"),
        ATT_TYPE_BOOLEAN("BOOLEAN"),
        ATT_TYPE_LIST("LIST"),
        ATT_TYPE_RELATIONAL("RELATIONAL"),
        ATT_TYPE_REFERENCE("ID(");

        private String value;

        private SchemaTokens(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

