/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bauhaus;

import de.uni_bremen.st.rcf.exceptions.NoSuchRelationException;
import de.uni_bremen.st.rcf.exceptions.RelationExistsException;
import de.uni_bremen.st.rcf.persistence.AbstractRCFBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.RelationBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.Writer;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RCFBinding
extends AbstractRCFBinding {
    private File file;
    private Map<String, RelationBinding> relations;

    public RCFBinding(File source) {
        this.file = source;
        this.relations = new HashMap<String, RelationBinding>();
    }

    @Override
    public AbstractRelationBinding addRelation(String name) {
        if (this.hasRelation(name)) {
            throw new RelationExistsException();
        }
        RelationBinding rel = new RelationBinding(this, name);
        this.relations.put(name, rel);
        return rel;
    }

    @Override
    public AbstractRelationBinding getRelation(String name) {
        if (!this.hasRelation(name)) {
            throw new NoSuchRelationException();
        }
        return this.relations.get(name);
    }

    @Override
    public List<AbstractRelationBinding> getRelations() {
        return new ArrayList<AbstractRelationBinding>(this.relations.values());
    }

    @Override
    public boolean hasRelation(String name) {
        return this.relations.containsKey(name);
    }

    @Override
    public void save() {
        this.saveAs(this.getFile());
    }

    @Override
    public void saveAs(File f) {
        Writer w = new Writer(this);
        try {
            w.write(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

