/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bauhaus;

import de.uni_bremen.st.rcf.exceptions.ValueNotSetException;
import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.AbstractValueListBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.RelationBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.ValueListBinding;
import java.util.NoSuchElementException;

public class EntryBinding
extends AbstractEntryBinding {
    protected int offset = -1;
    private int lastDeletion;
    protected static final int UNSET_INT_VALUE = Integer.MIN_VALUE;
    protected static final float UNSET_FLOAT_VALUE = -3.40282E38f;
    protected static final String UNSET_STRING_VALUE = "__unset_str__";
    protected static final byte UNSET_BOOLEAN_VALUE = -1;
    protected static final byte TRUE_BOOLEAN_VALUE = 1;
    protected static final byte FALSE_BOOLEAN_VALUE = 0;

    protected EntryBinding(AbstractRelationBinding relation, int id) {
        super(relation, id);
        this.setOffset();
        this.lastDeletion = ((RelationBinding)relation).lastDeletion;
    }

    private void setOffset() {
        RelationBinding rel = (RelationBinding)this.relation;
        AttributeBinding idAttribute = rel.getIdAttribute();
        if (idAttribute.intData.size() < this.id) {
            for (int i = idAttribute.intData.size() - 1; i > -1; --i) {
                if (idAttribute.intData.get(i) != this.id) continue;
                this.offset = i;
                break;
            }
        } else {
            int search = this.id - 1;
            if (idAttribute.intData.get(search) == this.id) {
                this.offset = search;
            } else {
                for (int i = search - 1; i > -1; --i) {
                    if (idAttribute.intData.get(i) != this.id) continue;
                    this.offset = i;
                    break;
                }
            }
        }
        if (this.offset == -1) {
            throw new NoSuchElementException();
        }
    }

    private void updateOffset() {
        if (this.lastDeletion < ((RelationBinding)this.relation).lastDeletion) {
            this.setOffset();
            this.lastDeletion = ((RelationBinding)this.relation).lastDeletion;
        }
    }

    @Override
    public int getId() {
        this.updateOffset();
        RelationBinding rel = (RelationBinding)this.relation;
        AttributeBinding idAttribute = rel.getIdAttribute();
        return idAttribute.intData.get(this.offset);
    }

    @Override
    public boolean isSet(AbstractAttributeBinding attribute) {
        this.updateOffset();
        AttributeBinding a = (AttributeBinding)attribute;
        if (a.isList()) {
            return true;
        }
        switch (attribute.getType()) {
            case INTEGER: 
            case REFERENCE: {
                return a.intData.get(this.offset) != Integer.MIN_VALUE;
            }
            case FLOAT: {
                return a.floatData.get(this.offset) != -3.40282E38f;
            }
            case BOOLEAN: {
                return a.boolData.get(this.offset) != -1;
            }
            case STRING: {
                return !a.stringData.get(this.offset).equals(UNSET_STRING_VALUE);
            }
        }
        throw new RuntimeException();
    }

    @Override
    public int getInt(AbstractAttributeBinding attribute) {
        this.updateOffset();
        int value = ((AttributeBinding)attribute).intData.get(this.offset);
        if (value == Integer.MIN_VALUE) {
            throw new ValueNotSetException();
        }
        return value;
    }

    @Override
    public void setInt(AbstractAttributeBinding attribute, int value) {
        this.updateOffset();
        ((AttributeBinding)attribute).intData.set(this.offset, value);
    }

    @Override
    public float getFloat(AbstractAttributeBinding attribute) {
        this.updateOffset();
        float value = ((AttributeBinding)attribute).floatData.get(this.offset);
        if (value == -3.40282E38f) {
            throw new ValueNotSetException();
        }
        return value;
    }

    @Override
    public void setFloat(AbstractAttributeBinding attribute, float value) {
        this.updateOffset();
        ((AttributeBinding)attribute).floatData.set(this.offset, value);
    }

    @Override
    public String getString(AbstractAttributeBinding attribute) {
        this.updateOffset();
        String value = ((AttributeBinding)attribute).stringData.get(this.offset);
        if (value.equals(UNSET_STRING_VALUE)) {
            throw new ValueNotSetException();
        }
        return value;
    }

    @Override
    public void setString(AbstractAttributeBinding attribute, String value) {
        this.updateOffset();
        ((AttributeBinding)attribute).stringData.set(this.offset, value);
    }

    @Override
    public boolean getBool(AbstractAttributeBinding attribute) {
        this.updateOffset();
        byte value = ((AttributeBinding)attribute).boolData.get(this.offset);
        if (value == 1) {
            return true;
        }
        if (value == 0) {
            return false;
        }
        if (value == -1) {
            throw new ValueNotSetException();
        }
        throw new AssertionError();
    }

    @Override
    public void setBool(AbstractAttributeBinding attribute, boolean value) {
        this.updateOffset();
        byte i = value ? (byte)1 : 0;
        ((AttributeBinding)attribute).boolData.set(this.offset, i);
    }

    @Override
    public <T> AbstractValueListBinding<T> getList(AbstractAttributeBinding attribute) {
        this.updateOffset();
        return new ValueListBinding(attribute, this);
    }

    @Override
    public AbstractEntryBinding getEntry(AbstractAttributeBinding attribute) throws ValueNotSetException {
        this.updateOffset();
        int id = this.getInt(attribute);
        AbstractRelationBinding rel = attribute.getReferencedRelation();
        return new EntryBinding(rel, id);
    }

    @Override
    public void setEntry(AbstractAttributeBinding attribute, AbstractEntryBinding value) {
        this.updateOffset();
        this.setInt(attribute, value.getId());
    }

    public boolean equals(Object obj) {
        this.updateOffset();
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntryBinding other = (EntryBinding)obj;
        return this.id == other.id && this.relation == other.relation;
    }

    public int hashCode() {
        this.updateOffset();
        return this.id * this.relation.hashCode();
    }

    @Override
    public void delete() {
        this.updateOffset();
        this.relation.deleteEntry(this.getId());
    }

    @Override
    public void unset(AbstractAttributeBinding attribute) {
        this.updateOffset();
        AttributeBinding a = (AttributeBinding)attribute;
        if (a.isList()) {
            return;
        }
        switch (attribute.getType()) {
            case INTEGER: 
            case REFERENCE: {
                this.setInt(attribute, Integer.MIN_VALUE);
                break;
            }
            case FLOAT: {
                this.setFloat(attribute, -3.40282E38f);
                break;
            }
            case BOOLEAN: {
                a.boolData.set(this.offset, (byte)-1);
                break;
            }
            case STRING: {
                this.setString(attribute, UNSET_STRING_VALUE);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }
}

