/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bauhaus;

import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.persistence.AbstractPersistenceManager;
import de.uni_bremen.st.rcf.persistence.FormatInfo;
import de.uni_bremen.st.rcf.persistence.PersistenceManagerFactory;
import de.uni_bremen.st.rcf.persistence.bauhaus.IReader;
import de.uni_bremen.st.rcf.persistence.bauhaus.RCFBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.Reader20;
import de.uni_bremen.st.rcf.persistence.bauhaus.Reader21;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BauhausPersistenceManager
extends AbstractPersistenceManager {
    @Override
    public RCF create(File source) {
        RCFBinding binding = new RCFBinding(source);
        return new RCF(binding);
    }

    @Override
    public RCF load(File source) {
        FormatInfo fi = null;
        try {
            fi = PersistenceManagerFactory.getFormatInfo(source);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.load(source, fi);
    }

    private RCF load(File source, FormatInfo fi) {
        IReader reader = null;
        if (fi.getMajorVersion() == 2) {
            if (fi.getMinorVersion() == 0) {
                reader = new Reader20(source);
            } else if (fi.getMinorVersion() == 1) {
                reader = new Reader21(source);
            }
        } else {
            throw new RuntimeException();
        }
        try {
            reader.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RCF rcf = new RCF(reader.getRCFBinding());
        this.makeDirectoryPointers(rcf);
        return rcf;
    }

    private void makeDirectoryPointers(RCF rcf) {
        if (rcf.getFiles().size() == 0) {
            return;
        }
        de.uni_bremen.st.rcf.model.File f = (de.uni_bremen.st.rcf.model.File)rcf.getFiles().getFirstEntry();
        if (f.getDirectory().getFiles().size() > 0) {
            return;
        }
        for (de.uni_bremen.st.rcf.model.File file : rcf.getFiles()) {
            file.getDirectory().getFiles().add(file);
        }
    }
}

