/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bauhaus;

import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.RelationBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import gnu.trove.TByteArrayList;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;

public class AttributeBinding
extends AbstractAttributeBinding {
    protected final TIntArrayList intData = new TIntArrayList();
    protected final TFloatArrayList floatData = new TFloatArrayList();
    protected final ArrayList<String> stringData = new ArrayList();
    protected final TByteArrayList boolData = new TByteArrayList();
    protected final TIntArrayList listStarts = new TIntArrayList();
    protected final TIntArrayList listEnds = new TIntArrayList();
    protected final TIntArrayList nextIndex = new TIntArrayList();
    private final String name;
    private AttributeType type;
    private final boolean isList;
    private final boolean isEnum;
    private final ArrayList<String> enumValues;
    private final String description;
    private final RelationBinding referencedRelation;

    protected AttributeBinding(String name, AttributeType type, boolean isList, boolean isEnum, String[] enumValues, RelationBinding relation, RelationBinding referencedRelation) {
        super(name, relation);
        this.name = name;
        this.type = type;
        this.isList = isList;
        this.isEnum = isEnum;
        if (enumValues != null) {
            this.enumValues = new ArrayList();
            for (String s : enumValues) {
                this.enumValues.add(s);
            }
        } else {
            this.enumValues = null;
        }
        this.description = "";
        this.referencedRelation = referencedRelation;
        this.unsetValues();
    }

    private void unsetValues() {
        if (this.name.equals("id")) {
            return;
        }
        int numEntries = ((RelationBinding)this.relation).getIdAttribute().intData.size();
        if (this.isList) {
            this.listStarts.fill(0, numEntries, -1);
            this.listEnds.fill(0, numEntries, -1);
        } else {
            switch (this.type) {
                case INTEGER: 
                case REFERENCE: {
                    for (int i = 0; i < numEntries; ++i) {
                        this.intData.add(Integer.MIN_VALUE);
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < numEntries; ++i) {
                        this.floatData.add(-3.40282E38f);
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < numEntries; ++i) {
                        this.stringData.add("__unset_str__");
                    }
                    break;
                }
                case BOOLEAN: {
                    for (int i = 0; i < numEntries; ++i) {
                        this.boolData.add((byte)-1);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public boolean isEnum() {
        return this.isEnum;
    }

    @Override
    public List<String> getEnumValues() {
        if (this.enumValues != null) {
            return new ArrayList<String>(this.enumValues);
        }
        return new ArrayList<String>();
    }

    @Override
    public AbstractRelationBinding getReferencedRelation() {
        return this.referencedRelation;
    }

    protected void setType(AttributeType type) {
        this.type = type;
    }
}

