/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.AbstractRCF;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.EntryType;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;

public class SourcePositions
extends Relation<SourcePosition> {
    private final Attribute id = this.getAttribute("id");
    private final Attribute file = this.getAttribute("file");
    private final Attribute line = this.getAttribute("line");
    private final Attribute column = this.getAttribute("column");
    private final Attribute offset = this.getAttribute("offset");

    protected SourcePositions(AbstractRelationBinding binding, AbstractRCF rcf) {
        super(binding, rcf, EntryType.toEntryType("SourcePosition"), true);
    }

    public Attribute getIdAttribute() {
        return this.id;
    }

    public Attribute getFileAttribute() {
        return this.file;
    }

    public Attribute getLineAttribute() {
        return this.line;
    }

    public Attribute getColumnAttribute() {
        return this.column;
    }

    public Attribute getOffsetAttribute() {
        return this.offset;
    }

    public SourcePosition addSourcePosition(File file, int line, int column) {
        assert (file != null);
        assert (line >= 0);
        assert (column >= 0);
        SourcePosition sourcePos = (SourcePosition)this.append();
        sourcePos.setFile(file);
        sourcePos.setLine(line);
        sourcePos.setColumn(column);
        return sourcePos;
    }

    public SourcePosition addSourcePosition(File file, int offset) {
        assert (file != null);
        assert (offset >= 0);
        SourcePosition sourcePos = (SourcePosition)this.append();
        sourcePos.setFile(file);
        sourcePos.setOffset(offset);
        return sourcePos;
    }
}

