/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.AbstractRCF;
import de.uni_bremen.st.rcf.model.CloneClasses;
import de.uni_bremen.st.rcf.model.ClonePairs;
import de.uni_bremen.st.rcf.model.Directories;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.EntryType;
import de.uni_bremen.st.rcf.model.Files;
import de.uni_bremen.st.rcf.model.Fragments;
import de.uni_bremen.st.rcf.model.Metadatas;
import de.uni_bremen.st.rcf.model.ProcessDatas;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.SourcePositions;
import de.uni_bremen.st.rcf.model.Versions;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;

public class RelationFactory {
    protected static Relation<? extends Entry> createRelation(String name, AbstractRelationBinding arb, AbstractRCF rcf) {
        EntryType type = EntryType.toEntryType(name);
        switch (type) {
            case CLONEPAIR: {
                return new ClonePairs(arb, rcf);
            }
            case FILE: {
                return new Files(arb, rcf);
            }
            case CLONECLASS: {
                return new CloneClasses(arb, rcf);
            }
            case SOURCEPOSITION: {
                return new SourcePositions(arb, rcf);
            }
            case METADATA: {
                return new Metadatas(arb, rcf);
            }
            case VERSION: {
                return new Versions(arb, rcf);
            }
            case DIRECTORY: {
                return new Directories(arb, rcf);
            }
            case FRAGMENT: {
                return new Fragments(arb, rcf);
            }
            case PROCESSDATA: {
                return new ProcessDatas(arb, rcf);
            }
            case ENTRY: {
                return new Relation(arb, rcf);
            }
        }
        throw new AssertionError();
    }

    protected static Relation<? extends Entry> createGenericRelation(String name, AbstractRelationBinding arb, AbstractRCF rcf) {
        return new Relation(arb, rcf);
    }
}

