/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.util.ArrayList;
import java.util.List;

public final class Attribute {
    private final Relation<? extends Entry> relation;
    protected final AbstractAttributeBinding binding;
    private final String name;
    private final AttributeType type;
    private final boolean isList;
    private final boolean isEnum;
    private Relation<? extends Entry> referencedRelation;
    private final List<String> enumValues;

    protected Attribute(AbstractAttributeBinding binding, Relation<? extends Entry> relation, boolean constructionPhase) {
        this.relation = relation;
        this.binding = binding;
        this.name = binding.getName();
        this.type = binding.getType();
        this.isList = binding.isList();
        this.isEnum = binding.isEnum();
        this.referencedRelation = constructionPhase ? null : (binding.getReferencedRelation() == null ? null : relation.getRCF().getRelation(binding.getReferencedRelation().getName()));
        this.enumValues = binding.getEnumValues();
    }

    protected Attribute(AbstractAttributeBinding binding, Relation<? extends Entry> relation) {
        this(binding, relation, false);
    }

    public String getName() {
        return this.name;
    }

    public AttributeType getType() {
        return this.type;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public Relation<? extends Entry> getRelation() {
        return this.relation;
    }

    public Relation<? extends Entry> getReferencedRelation() {
        return this.referencedRelation;
    }

    protected void setReferencedRelation(Relation<? extends Entry> relation) {
        this.referencedRelation = relation;
    }

    public List<String> getEnumValues() {
        return new ArrayList<String>(this.enumValues);
    }

    protected AbstractAttributeBinding getBinding() {
        return this.binding;
    }
}

