/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports.ccfx;

import de.uni_bremen.st.rcf.imports.ccfx.CloneClass;
import de.uni_bremen.st.rcf.imports.ccfx.ClonePair;
import de.uni_bremen.st.rcf.imports.ccfx.ClonePart;
import de.uni_bremen.st.rcf.imports.ccfx.exception.ModelInvokationExcpetion;
import de.uni_bremen.st.rcf.imports.ccfx.util.CCFXClonePair;
import de.uni_bremen.st.rcf.imports.ccfx.util.CCFXClonePart;
import de.uni_bremen.st.rcf.imports.ccfx.util.CCFXToken;
import de.uni_bremen.st.rcf.imports.ccfx.util.ScannedFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class Model {
    private static final String FILE_SEPARATOR_STR = File.separator;
    private static final char FILE_SEPARATOR_CHAR = File.separatorChar;
    private static final String VERSION = "version";
    private static final String FORMAT = "format";
    private static final String OPTION = "option";
    private static final String PREPROCESS_SCRIPT = "preprocess_script";
    private static final String SOURCE_FILES = "source_files {";
    private static final String CLONE_PAIRS = "clone_pairs {";
    private static final String CCFX_PREPDIR_OPTION = "-n";
    private static final String PREPROCESSED_FILE_POSTFIX = "-preprocessed_file_postfix";
    private static final String CCFXPREPDIR = ".ccfxprepdir";
    private File ccfxFile;
    private File scannedDir;
    private File baseDir;
    private File ccfxPrepDirPath;
    private String version;
    private String format;
    private String preprocessScript;
    private Map<String, String> options = new HashMap<String, String>();
    private List<ScannedFile> scannedFiles = new ArrayList<ScannedFile>();
    private Map<Integer, List<CCFXClonePair>> ccfxClones = new HashMap<Integer, List<CCFXClonePair>>();

    public Model(File file) throws IllegalArgumentException, FileNotFoundException, IOException {
        this.parse(file);
    }

    public Model(File file, File baseDir) throws FileNotFoundException, IOException {
        if (null == baseDir) {
            throw new IllegalArgumentException("unexpected null-value for parameter baseDir");
        }
        if (!(baseDir.exists() && baseDir.isDirectory() && baseDir.canRead())) {
            throw new FileNotFoundException("parameter baseDir is not a valid path");
        }
        this.baseDir = baseDir;
        this.parse(file);
    }

    public List<ClonePair> getClonePairs() {
        ArrayList<ClonePair> clonePairs = new ArrayList<ClonePair>();
        for (Integer id : this.ccfxClones.keySet()) {
            clonePairs.addAll(this.getClonePairsById(id));
        }
        return clonePairs;
    }

    public List<CloneClass> getCloneClasses() {
        ArrayList<CloneClass> cloneClasses = new ArrayList<CloneClass>();
        for (int id : this.ccfxClones.keySet()) {
            CloneClass cloneClass = new CloneClass(id);
            cloneClass.getClonePairs().addAll(this.getClonePairsById(id));
            cloneClasses.add(cloneClass);
        }
        return cloneClasses;
    }

    private void parse(File file) throws IllegalArgumentException, FileNotFoundException, IOException {
        if (null == file) {
            throw new IllegalArgumentException("unexpected null-value for parameter file");
        }
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new FileNotFoundException("parameter file is not a valid file");
        }
        this.ccfxFile = file;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.ccfxFile));
        this.parseOptions(bufferedReader);
        this.parseScannedFiles(bufferedReader);
        this.skipTo(CLONE_PAIRS, bufferedReader);
        this.parseClonePairs(bufferedReader);
    }

    private void parseOptions(BufferedReader bufferedReader) throws IOException {
        String line;
        while (!(line = bufferedReader.readLine()).equals(SOURCE_FILES)) {
            String value;
            Scanner scanner = new Scanner(line);
            scanner.useDelimiter(":");
            String option = scanner.next();
            scanner.skip(": ");
            if (option.equals(VERSION) || option.equals(FORMAT) || option.equals(PREPROCESS_SCRIPT)) {
                value = scanner.nextLine();
                if (option.equals(VERSION)) {
                    this.version = value;
                    continue;
                }
                if (option.equals(FORMAT)) {
                    this.format = value;
                    continue;
                }
                if (!option.equals(PREPROCESS_SCRIPT)) continue;
                this.preprocessScript = value;
                continue;
            }
            if (!option.equals(OPTION)) continue;
            scanner.useDelimiter(" ");
            option = scanner.next();
            value = scanner.next();
            if (option.equals(CCFX_PREPDIR_OPTION)) {
                this.scannedDir = new File(this.correctPath(value));
                if (!(null != this.baseDir || this.scannedDir.exists() && this.scannedDir.isDirectory() && this.scannedDir.canRead())) {
                    throw new FileNotFoundException("parsed value of option ".concat(CCFX_PREPDIR_OPTION).concat(" is not a valid path"));
                }
                this.ccfxPrepDirPath = new File(this.stripPath(value.concat(FILE_SEPARATOR_STR).concat(CCFXPREPDIR)));
                if (!(this.ccfxPrepDirPath.exists() && this.ccfxPrepDirPath.isDirectory() && this.ccfxPrepDirPath.canRead())) {
                    throw new FileNotFoundException("the ccfxprepdir-path ".concat(this.ccfxPrepDirPath.getPath().concat(" is not a valid path")));
                }
            }
            this.options.put(option, value);
        }
    }

    private void parseScannedFiles(BufferedReader bufferedReader) throws IOException {
        String line;
        while (!(line = bufferedReader.readLine()).equals("}")) {
            if (null == this.ccfxPrepDirPath) {
                throw new ModelInvokationExcpetion("unexpected null-value for ccfxprepdir");
            }
            Scanner scanner = new Scanner(line);
            int id = scanner.nextInt();
            scanner.skip("\t");
            String scannedFile = scanner.next();
            scannedFile = this.stripPath(scannedFile);
            String ccfxPrepFile = this.getCCFXPrepFile(scannedFile);
            this.scannedFiles.add(new ScannedFile(id, new File(scannedFile), new File(ccfxPrepFile)));
        }
    }

    private void parseClonePairs(BufferedReader bufferedReader) throws IOException {
        String line;
        while (!(line = bufferedReader.readLine()).equals("}")) {
            Scanner scanner = new Scanner(line);
            int id = scanner.nextInt();
            scanner.skip("\t");
            scanner.useDelimiter("\t");
            CCFXClonePart left = this.scanCCFXClonePart(scanner.next());
            CCFXClonePart right = this.scanCCFXClonePart(scanner.next());
            CCFXClonePair ccfxClonePair = new CCFXClonePair(id, left, right);
            List<CCFXClonePair> ccfxClonePairs = this.ccfxClones.get(id);
            if (null == ccfxClonePairs) {
                ccfxClonePairs = new ArrayList<CCFXClonePair>();
                this.ccfxClones.put(id, ccfxClonePairs);
            }
            ccfxClonePairs.add(ccfxClonePair);
        }
    }

    private void skipTo(String skipTo, BufferedReader bufferedReader) throws IOException {
        String line;
        while (!(line = bufferedReader.readLine()).equals(skipTo)) {
        }
    }

    private String stripPath(String path) {
        path = this.correctPath(path);
        if (null != this.baseDir) {
            if (null == this.scannedDir) {
                throw new ModelInvokationExcpetion("unexpected null-value for scanned directory (-n option in ccfx)");
            }
            path = path.replaceAll(this.scannedDir.getPath(), this.baseDir.getPath());
        }
        return path;
    }

    private String correctPath(String path) {
        path = path.replaceAll("/", FILE_SEPARATOR_STR);
        char lastChar = (path = path.replaceAll("\\\\", FILE_SEPARATOR_STR)).charAt(path.length() - 1);
        if (lastChar == FILE_SEPARATOR_CHAR) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private CCFXClonePart scanCCFXClonePart(String clonePartInformation) {
        Scanner scanner = new Scanner(clonePartInformation);
        scanner.useDelimiter("\\.");
        int fileId = Integer.parseInt(scanner.next());
        scanner.skip("\\.");
        scanner.useDelimiter("-");
        int beginToken = Integer.parseInt(scanner.next());
        scanner.skip("-");
        int endToken = Integer.parseInt(scanner.nextLine());
        ScannedFile scannedFile = this.scannedFiles.get(fileId - 1);
        return new CCFXClonePart(fileId, scannedFile.getCCFXTokens().get(beginToken), scannedFile.getCCFXTokens().get(endToken - 1), endToken - beginToken);
    }

    private Set<ClonePair> getClonePairsById(int id) {
        LinkedHashSet<ClonePair> clonePairs = new LinkedHashSet<ClonePair>();
        for (CCFXClonePair ccfxClonePair : this.ccfxClones.get(id)) {
            clonePairs.add(this.toClonePair(ccfxClonePair));
        }
        return clonePairs;
    }

    private String getCCFXPrepFile(String scannedFile) {
        String preprocessedFilePostFix = this.options.get(PREPROCESSED_FILE_POSTFIX);
        if (null == preprocessedFilePostFix) {
            throw new ModelInvokationExcpetion("unexpected null-value for preprocessed_file_postfix");
        }
        return this.ccfxPrepDirPath.getPath().concat(FILE_SEPARATOR_STR).concat(scannedFile.substring(this.ccfxPrepDirPath.getPath().length() - CCFXPREPDIR.length())).concat(preprocessedFilePostFix);
    }

    private ClonePair toClonePair(CCFXClonePair ccfxClonePair) {
        CCFXClonePart left = ccfxClonePair.getLeft();
        CCFXClonePart right = ccfxClonePair.getRight();
        return new ClonePair(ccfxClonePair.getId(), this.toClonePart(left), this.toClonePart(right));
    }

    private ClonePart toClonePart(CCFXClonePart ccfxClonePart) {
        int fileId = ccfxClonePart.getFileId();
        ScannedFile scannedFile = this.scannedFiles.get(fileId - 1);
        CCFXToken ccfxTokenBegin = ccfxClonePart.getBeginToken();
        int beginLine = ccfxTokenBegin.getLineInt();
        int beginColumn = ccfxTokenBegin.getColumnInt();
        int beginOffset = ccfxTokenBegin.getOffsetInt();
        CCFXToken ccfxTokenEnd = ccfxClonePart.getEndToken();
        int endLine = ccfxTokenEnd.getLineInt();
        int endColumn = ccfxTokenEnd.getColumnInt();
        int endOffset = ccfxTokenEnd.getOffsetInt();
        return new ClonePart(scannedFile.getFile(), beginLine, beginColumn, beginOffset, endLine, endColumn, endOffset, ccfxClonePart.getNumTokens());
    }

    public static void main(String[] args) throws Exception {
        File prettyPrint = new File("/home/marcel/Downloads/ccfx/scans/resync.pretty");
        File sourceDir = new File("/home/marcel/Downloads/ccfx/sources/resync/src/");
        new Model(prettyPrint, sourceDir).getCloneClasses();
    }
}

