/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractImport;
import de.uni_bremen.st.rcf.imports.ImportUtils;
import de.uni_bremen.st.rcf.model.ClonePairs;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Fragments;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.util.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class CPFImport
extends AbstractImport {
    private static final int CPF_FILE_1 = 0;
    private static final int CPF_BEGIN_1 = 1;
    private static final int CPF_END_1 = 2;
    private static final int CPF_FILE_2 = 3;
    private static final int CPF_BEGIN_2 = 4;
    private static final int CPF_END_2 = 5;
    private static final int CPF_CLONE_TYPE = 6;
    private static final int CPF_LEN_TKOKEN = 8;

    public CPFImport(File rcfFile) {
        super(rcfFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Version addVersion(File cpfFile, String basepath) {
        if (cpfFile == null) {
            throw new IllegalArgumentException("cpfFile and rcfFile must not be null.");
        }
        ClonePairs cpRel = this.rcf.getClonePairs();
        Fragments fragRel = this.rcf.getFragments();
        Version v = super.addVersion(cpfFile, basepath);
        BufferedReader bIn = null;
        String line = null;
        try {
            bIn = new BufferedReader(new FileReader(cpfFile));
            line = bIn.readLine();
            int lineNumber = 1;
            while (line != null) {
                String[] values = line.split("\t");
                if (values.length != 9) {
                    ImportUtils.reportError(cpfFile, lineNumber, line, null);
                }
                String fileNameLeft = values[0];
                int beginLineLeft = 0;
                int endLineLeft = 0;
                String fileNameRight = values[3];
                int beginLineRight = 0;
                int endLineRight = 0;
                int cloneType = 0;
                int numTokens = 0;
                fileNameLeft = PathUtils.stripBasepath(basepath, fileNameLeft);
                fileNameRight = PathUtils.stripBasepath(basepath, fileNameRight);
                try {
                    beginLineLeft = Integer.parseInt(values[1]);
                    endLineLeft = Integer.parseInt(values[2]);
                    beginLineRight = Integer.parseInt(values[4]);
                    endLineRight = Integer.parseInt(values[5]);
                    cloneType = Integer.parseInt(values[6]);
                    numTokens = Integer.parseInt(values[8]);
                }
                catch (NumberFormatException nfe) {
                    ImportUtils.reportError(cpfFile, lineNumber, line, nfe);
                }
                Fragment left = fragRel.addFragment(fileNameLeft, v, beginLineLeft, endLineLeft, 0, 0, numTokens);
                Fragment right = fragRel.addFragment(fileNameRight, v, beginLineRight, endLineRight, 0, 0, numTokens);
                cpRel.addClonePair(v, 0, cloneType, left, right);
                line = bIn.readLine();
                ++lineNumber;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bIn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return v;
    }
}

