/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractImport;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CPDImport
extends AbstractImport {
    private static final String CPD_DUPLICATION = "duplication";
    private static final String CPD_FRAGMENT = "file";
    private static final String CPD_LINES = "lines";
    private static final String CPD_TOKENS = "tokens";
    private static final String CPD_PATH = "path";
    private static final String CPD_LINE = "line";

    public CPDImport(File rcfFile) {
        super(rcfFile);
    }

    @Override
    public Version addVersion(File cpdFile, String basepath) {
        Version v = super.addVersion(cpdFile, basepath);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            CPDSAXHandler handler = new CPDSAXHandler(v, basepath);
            saxParser.parse(cpdFile, (DefaultHandler)handler);
        }
        catch (IOException ioe) {
        }
        catch (SAXException se) {
        }
        catch (ParserConfigurationException pce) {
            // empty catch block
        }
        return v;
    }

    public class CPDSAXHandler
    extends DefaultHandler {
        private final Version v;
        private final String basepath;
        private List<Fragment> fragments;
        private int curLines;
        private int curTokens;

        public CPDSAXHandler(Version v, String basepath) {
            this.v = v;
            this.basepath = basepath;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals(CPDImport.CPD_DUPLICATION)) {
                this.fragments = new ArrayList<Fragment>();
                this.curLines = Integer.parseInt(attributes.getValue(CPDImport.CPD_LINES));
                this.curTokens = Integer.parseInt(attributes.getValue(CPDImport.CPD_TOKENS));
            } else if (name.equals(CPDImport.CPD_FRAGMENT)) {
                String path = attributes.getValue(CPDImport.CPD_PATH);
                path = PathUtils.stripBasepath(this.basepath, path);
                int beginLine = Integer.parseInt(attributes.getValue(CPDImport.CPD_LINE));
                int endLine = beginLine + this.curLines;
                Fragment f = CPDImport.this.rcf.getFragments().addFragment(path, this.v, beginLine, endLine, 0, 0, this.curTokens);
                this.fragments.add(f);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals(CPDImport.CPD_DUPLICATION)) {
                CPDImport.this.rcf.getCloneClasses().addCloneClass(this.v, 0, 1, this.fragments);
            }
        }
    }
}

