/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractImport;
import de.uni_bremen.st.rcf.imports.ccfx.CloneClass;
import de.uni_bremen.st.rcf.imports.ccfx.ClonePair;
import de.uni_bremen.st.rcf.imports.ccfx.ClonePart;
import de.uni_bremen.st.rcf.imports.ccfx.Model;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Version;
import java.io.File;
import java.util.LinkedList;

public class CCFXImport
extends AbstractImport {
    public CCFXImport(File rcfFile) {
        super(rcfFile);
    }

    @Override
    public Version addVersion(File sourceFile, String basepath) {
        Version v = super.addVersion(sourceFile, basepath);
        try {
            Model model = new Model(sourceFile, new File(basepath));
            for (CloneClass cloneClass : model.getCloneClasses()) {
                LinkedList<Fragment> fragments = new LinkedList<Fragment>();
                for (ClonePair clonePair : cloneClass.getClonePairs()) {
                    for (ClonePart clonePart : clonePair.getParts()) {
                        fragments.add(this.rcf.getFragments().addFragment(clonePart.getFile(), v, clonePart.getBeginOffset(), clonePart.getEndOffset(), clonePart.getNumTokens()));
                    }
                }
                this.rcf.getCloneClasses().addCloneClass(v, cloneClass.getId(), 0, fragments);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return v;
    }
}

